/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.producer.KafkaHeader;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import io.vertx.kafka.client.producer.impl.KafkaHeaderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.internals.RecordHeader;

public class KafkaProducerRecordImpl<K, V>
implements KafkaProducerRecord<K, V> {
    private final String topic;
    private final K key;
    private final V value;
    private final Long timestamp;
    private final Integer partition;
    private final List<KafkaHeader> headers = new ArrayList<KafkaHeader>();

    public KafkaProducerRecordImpl(String topic, K key, V value, Long timestamp, Integer partition) {
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.timestamp = timestamp;
        this.partition = partition;
    }

    public KafkaProducerRecordImpl(String topic, K key, V value, Integer partition) {
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.timestamp = null;
        this.partition = partition;
    }

    public KafkaProducerRecordImpl(String topic, K key, V value) {
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.timestamp = null;
        this.partition = null;
    }

    public KafkaProducerRecordImpl(String topic, V value) {
        this.topic = topic;
        this.key = null;
        this.value = value;
        this.timestamp = null;
        this.partition = null;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public Long timestamp() {
        return this.timestamp;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public Integer partition() {
        return this.partition;
    }

    @Override
    public KafkaProducerRecord<K, V> addHeader(String key, Buffer value) {
        return this.addHeader(new KafkaHeaderImpl(key, value));
    }

    @Override
    public KafkaProducerRecord<K, V> addHeader(String key, String value) {
        return this.addHeader(new KafkaHeaderImpl(key, value));
    }

    @Override
    public KafkaProducerRecord<K, V> addHeader(KafkaHeader header) {
        this.headers.add(header);
        return this;
    }

    @Override
    public KafkaProducerRecord<K, V> addHeaders(List<KafkaHeader> headers) {
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public ProducerRecord record() {
        if (this.headers.isEmpty()) {
            return new ProducerRecord(this.topic, this.partition, this.timestamp, this.key, this.value);
        }
        return new ProducerRecord(this.topic, this.partition, this.timestamp, this.key, this.value, (Iterable)this.headers.stream().map(header -> new RecordHeader(header.key(), header.value().getBytes())).collect(Collectors.toList()));
    }

    @Override
    public List<KafkaHeader> headers() {
        return this.headers;
    }

    public String toString() {
        return "KafkaProducerRecord{topic=" + this.topic + ",partition=" + this.partition + ",timestamp=" + this.timestamp + ",key=" + this.key + ",value=" + this.value + ",headers=" + this.headers + "}";
    }
}

