/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin.impl;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.kafka.admin.Config;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.KafkaAdminClient;
import io.vertx.kafka.admin.MemberDescription;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.client.common.ConfigResource;
import io.vertx.kafka.client.common.impl.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.common.TopicPartitionInfo;

@VertxGen
public class KafkaAdminClientImpl
implements KafkaAdminClient {
    private Vertx vertx;
    private AdminClient adminClient;

    public KafkaAdminClientImpl(Vertx vertx, AdminClient adminClient) {
        this.vertx = vertx;
        this.adminClient = adminClient;
    }

    @Override
    public void describeTopics(List<String> topicNames, Handler<AsyncResult<Map<String, TopicDescription>>> completionHandler) {
        DescribeTopicsResult describeTopicsResult = this.adminClient.describeTopics(topicNames);
        describeTopicsResult.all().whenComplete((t, ex) -> {
            if (ex == null) {
                HashMap topics = new HashMap();
                for (Map.Entry topicDescriptionEntry : t.entrySet()) {
                    ArrayList<io.vertx.kafka.client.common.TopicPartitionInfo> partitions = new ArrayList<io.vertx.kafka.client.common.TopicPartitionInfo>();
                    for (TopicPartitionInfo kafkaPartitionInfo : ((org.apache.kafka.clients.admin.TopicDescription)topicDescriptionEntry.getValue()).partitions()) {
                        io.vertx.kafka.client.common.TopicPartitionInfo topicPartitionInfo = new io.vertx.kafka.client.common.TopicPartitionInfo();
                        topicPartitionInfo.setIsr(kafkaPartitionInfo.isr().stream().map(Helper::from).collect(Collectors.toList())).setLeader(Helper.from(kafkaPartitionInfo.leader())).setPartition(kafkaPartitionInfo.partition()).setReplicas(kafkaPartitionInfo.replicas().stream().map(Helper::from).collect(Collectors.toList()));
                        partitions.add(topicPartitionInfo);
                    }
                    TopicDescription topicDescription = new TopicDescription();
                    topicDescription.setInternal(((org.apache.kafka.clients.admin.TopicDescription)topicDescriptionEntry.getValue()).isInternal()).setName((String)topicDescriptionEntry.getKey()).setPartitions(partitions);
                    topics.put(topicDescriptionEntry.getKey(), topicDescription);
                }
                completionHandler.handle((Object)Future.succeededFuture(topics));
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ex));
            }
        });
    }

    @Override
    public void listTopics(Handler<AsyncResult<Set<String>>> completionHandler) {
        ListTopicsResult listTopicsResult = this.adminClient.listTopics();
        listTopicsResult.names().whenComplete((topics, ex) -> {
            if (ex == null) {
                completionHandler.handle((Object)Future.succeededFuture((Object)topics));
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ex));
            }
        });
    }

    @Override
    public void createTopics(List<NewTopic> topics, Handler<AsyncResult<Void>> completionHandler) {
        CreateTopicsResult createTopicsResult = this.adminClient.createTopics(Helper.toNewTopicList(topics));
        createTopicsResult.all().whenComplete((v, ex) -> {
            if (ex == null) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ex));
            }
        });
    }

    @Override
    public void deleteTopics(List<String> topicNames, Handler<AsyncResult<Void>> completionHandler) {
        DeleteTopicsResult deleteTopicsResult = this.adminClient.deleteTopics(topicNames);
        deleteTopicsResult.all().whenComplete((v, ex) -> {
            if (ex == null) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ex));
            }
        });
    }

    @Override
    public void describeConfigs(List<ConfigResource> configResources, Handler<AsyncResult<Map<ConfigResource, Config>>> completionHandler) {
        DescribeConfigsResult describeConfigsResult = this.adminClient.describeConfigs(Helper.toConfigResourceList(configResources));
        describeConfigsResult.all().whenComplete((m, ex) -> {
            if (ex == null) {
                HashMap<ConfigResource, Config> configs = new HashMap<ConfigResource, Config>();
                for (Map.Entry configEntry : m.entrySet()) {
                    ConfigResource configResource = Helper.from((org.apache.kafka.common.config.ConfigResource)configEntry.getKey());
                    Config config = Helper.from((org.apache.kafka.clients.admin.Config)configEntry.getValue());
                    configs.put(configResource, config);
                }
                completionHandler.handle((Object)Future.succeededFuture(configs));
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ex));
            }
        });
    }

    @Override
    public void alterConfigs(Map<ConfigResource, Config> configs, Handler<AsyncResult<Void>> completionHandler) {
        AlterConfigsResult alterConfigsResult = this.adminClient.alterConfigs(Helper.toConfigMaps(configs));
        alterConfigsResult.all().whenComplete((v, ex) -> {
            if (ex == null) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ex));
            }
        });
    }

    @Override
    public void listConsumerGroups(Handler<AsyncResult<List<ConsumerGroupListing>>> completionHandler) {
        ListConsumerGroupsResult listConsumerGroupsResult = this.adminClient.listConsumerGroups();
        listConsumerGroupsResult.all().whenComplete((groupIds, ex) -> {
            if (ex == null) {
                completionHandler.handle((Object)Future.succeededFuture(Helper.fromConsumerGroupListings(groupIds)));
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ex));
            }
        });
    }

    @Override
    public void describeConsumerGroups(List<String> groupIds, Handler<AsyncResult<Map<String, ConsumerGroupDescription>>> completionHandler) {
        DescribeConsumerGroupsResult describeConsumerGroupsResult = this.adminClient.describeConsumerGroups(groupIds);
        describeConsumerGroupsResult.all().whenComplete((cg, ex) -> {
            if (ex == null) {
                HashMap consumerGroups = new HashMap();
                for (Map.Entry cgDescriptionEntry : cg.entrySet()) {
                    ArrayList<MemberDescription> members = new ArrayList<MemberDescription>();
                    for (org.apache.kafka.clients.admin.MemberDescription memberDescription : ((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).members()) {
                        MemberDescription m = new MemberDescription();
                        m.setConsumerId(memberDescription.consumerId()).setClientId(memberDescription.clientId()).setAssignment(Helper.from(memberDescription.assignment())).setHost(memberDescription.host());
                        members.add(m);
                    }
                    ConsumerGroupDescription consumerGroupDescription = new ConsumerGroupDescription();
                    consumerGroupDescription.setGroupId(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).groupId()).setCoordinator(Helper.from(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).coordinator())).setMembers(members).setPartitionAssignor(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).partitionAssignor()).setSimpleConsumerGroup(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).isSimpleConsumerGroup()).setState(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).state());
                    consumerGroups.put(cgDescriptionEntry.getKey(), consumerGroupDescription);
                }
                completionHandler.handle((Object)Future.succeededFuture(consumerGroups));
            } else {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ex));
            }
        });
    }
}

