/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.WriteStream;
import io.vertx.kafka.client.producer.impl.KafkaWriteStreamImpl;
import io.vertx.kafka.client.serialization.VertxSerdes;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.serialization.Serializer;

public interface KafkaWriteStream<K, V>
extends WriteStream<ProducerRecord<K, V>> {
    public static final int DEFAULT_MAX_SIZE = 0x100000;

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Properties config) {
        return KafkaWriteStreamImpl.create(vertx, config);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        Serializer keySerializer = VertxSerdes.serdeFrom(keyType).serializer();
        Serializer valueSerializer = VertxSerdes.serdeFrom(valueType).serializer();
        return KafkaWriteStreamImpl.create(vertx, config, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Properties config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return KafkaWriteStreamImpl.create(vertx, config, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Map<String, Object> config) {
        return KafkaWriteStreamImpl.create(vertx, config);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Map<String, Object> config, Class<K> keyType, Class<V> valueType) {
        Serializer keySerializer = VertxSerdes.serdeFrom(keyType).serializer();
        Serializer valueSerializer = VertxSerdes.serdeFrom(valueType).serializer();
        return KafkaWriteStreamImpl.create(vertx, config, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Map<String, Object> config, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return KafkaWriteStreamImpl.create(vertx, config, keySerializer, valueSerializer);
    }

    public static <K, V> KafkaWriteStream<K, V> create(Vertx vertx, Producer<K, V> producer) {
        return new KafkaWriteStreamImpl<K, V>(vertx.getOrCreateContext(), producer);
    }

    @Fluent
    public KafkaWriteStream<K, V> exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public KafkaWriteStream<K, V> setWriteQueueMaxSize(int var1);

    @Fluent
    public KafkaWriteStream<K, V> drainHandler(@Nullable Handler<Void> var1);

    public Future<RecordMetadata> send(ProducerRecord<K, V> var1);

    public KafkaWriteStream<K, V> send(ProducerRecord<K, V> var1, Handler<AsyncResult<RecordMetadata>> var2);

    public KafkaWriteStream<K, V> partitionsFor(String var1, Handler<AsyncResult<List<PartitionInfo>>> var2);

    public Future<List<PartitionInfo>> partitionsFor(String var1);

    public KafkaWriteStream<K, V> flush(Handler<AsyncResult<Void>> var1);

    public Future<Void> flush();

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    public void close(long var1, Handler<AsyncResult<Void>> var3);

    public Future<Void> close(long var1);

    public Producer<K, V> unwrap();
}

