/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.admin.Config;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.ListConsumerGroupOffsetsOptions;
import io.vertx.kafka.admin.ListOffsetsResultInfo;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.OffsetSpec;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.admin.impl.KafkaAdminClientImpl;
import io.vertx.kafka.client.common.ConfigResource;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;

@VertxGen
public interface KafkaAdminClient {
    @GenIgnore
    public static KafkaAdminClient create(Vertx vertx, AdminClient adminClient) {
        return new KafkaAdminClientImpl(vertx, adminClient);
    }

    public static KafkaAdminClient create(Vertx vertx, Map<String, String> config) {
        return KafkaAdminClient.create(vertx, AdminClient.create(new HashMap<String, String>(config)));
    }

    @GenIgnore
    public static KafkaAdminClient create(Vertx vertx, Properties config) {
        return KafkaAdminClient.create(vertx, AdminClient.create((Properties)config));
    }

    public void listTopics(Handler<AsyncResult<Set<String>>> var1);

    public Future<Set<String>> listTopics();

    public void describeTopics(List<String> var1, Handler<AsyncResult<Map<String, TopicDescription>>> var2);

    public Future<Map<String, TopicDescription>> describeTopics(List<String> var1);

    public void createTopics(List<NewTopic> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> createTopics(List<NewTopic> var1);

    public void deleteTopics(List<String> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deleteTopics(List<String> var1);

    @GenIgnore
    public void describeConfigs(List<ConfigResource> var1, Handler<AsyncResult<Map<ConfigResource, Config>>> var2);

    @GenIgnore
    public Future<Map<ConfigResource, Config>> describeConfigs(List<ConfigResource> var1);

    @GenIgnore
    public void alterConfigs(Map<ConfigResource, Config> var1, Handler<AsyncResult<Void>> var2);

    @GenIgnore
    public Future<Void> alterConfigs(Map<ConfigResource, Config> var1);

    public void listConsumerGroups(Handler<AsyncResult<List<ConsumerGroupListing>>> var1);

    public Future<List<ConsumerGroupListing>> listConsumerGroups();

    public void describeConsumerGroups(List<String> var1, Handler<AsyncResult<Map<String, ConsumerGroupDescription>>> var2);

    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> var1);

    public void describeCluster(Handler<AsyncResult<ClusterDescription>> var1);

    public Future<ClusterDescription> describeCluster();

    public void deleteConsumerGroups(List<String> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deleteConsumerGroups(List<String> var1);

    @GenIgnore
    public void listConsumerGroupOffsets(String var1, ListConsumerGroupOffsetsOptions var2, Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> var3);

    @GenIgnore
    public Future<Map<TopicPartition, OffsetAndMetadata>> listConsumerGroupOffsets(String var1, ListConsumerGroupOffsetsOptions var2);

    @GenIgnore
    default public void listConsumerGroupOffsets(String groupId, Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> completionHandler) {
        this.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions(), completionHandler);
    }

    @GenIgnore
    default public Future<Map<TopicPartition, OffsetAndMetadata>> listConsumerGroupOffsets(String groupId) {
        return this.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions());
    }

    public void deleteConsumerGroupOffsets(String var1, Set<TopicPartition> var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> deleteConsumerGroupOffsets(String var1, Set<TopicPartition> var2);

    @GenIgnore
    public void listOffsets(Map<TopicPartition, OffsetSpec> var1, Handler<AsyncResult<Map<TopicPartition, ListOffsetsResultInfo>>> var2);

    @GenIgnore
    public Future<Map<TopicPartition, ListOffsetsResultInfo>> listOffsets(Map<TopicPartition, OffsetSpec> var1);

    public Future<Void> close();

    public Future<Void> close(long var1);
}

