/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common.tracing;

import io.vertx.core.Context;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.common.tracing.TraceContext;
import io.vertx.kafka.client.common.tracing.TraceTags;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.utils.Utils;

public class ProducerTracer<S> {
    private final VertxTracer<Void, S> tracer;
    private final String address;
    private final String port;
    private final TracingPolicy policy;

    public static <S> ProducerTracer create(VertxTracer tracer, KafkaClientOptions opts) {
        TracingPolicy policy;
        TracingPolicy tracingPolicy = policy = opts.getTracingPolicy() != null ? opts.getTracingPolicy() : TracingPolicy.PROPAGATE;
        if (policy == TracingPolicy.IGNORE || tracer == null) {
            return null;
        }
        String address = opts.getTracePeerAddress();
        if (address == null) {
            address = opts.getConfig() != null ? (String)opts.getConfig().getOrDefault("bootstrap.servers", "") : "";
        }
        return new ProducerTracer<S>(tracer, policy, address);
    }

    private ProducerTracer(VertxTracer<Void, S> tracer, TracingPolicy policy, String bootstrapServer) {
        this.tracer = tracer;
        this.address = bootstrapServer;
        Integer port = Utils.getPort((String)bootstrapServer);
        this.port = port == null ? null : port.toString();
        this.policy = policy;
    }

    public StartedSpan prepareSendMessage(Context context, ProducerRecord record) {
        TraceContext tc = new TraceContext("producer", this.address, this.port, record.topic());
        Object span = this.tracer.sendRequest(context, SpanKind.MESSAGING, this.policy, (Object)tc, "kafka_send", (k, v) -> record.headers().add(k, v.getBytes()), TraceTags.TAG_EXTRACTOR);
        return new StartedSpan(span);
    }

    public class StartedSpan {
        private final S span;

        private StartedSpan(S span) {
            this.span = span;
        }

        public void finish(Context context) {
            ProducerTracer.this.tracer.receiveResponse(context, null, this.span, null, TagExtractor.empty());
        }

        public void fail(Context context, Throwable failure) {
            ProducerTracer.this.tracer.receiveResponse(context, null, this.span, failure, TagExtractor.empty());
        }
    }
}

