/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.MemberDescription;
import io.vertx.kafka.client.common.Node;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.acl.AclOperation;

public class ConsumerGroupDescriptionConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, ConsumerGroupDescription obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "groupId": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setGroupId((String)member.getValue());
                    break;
                }
                case "simpleConsumerGroup": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSimpleConsumerGroup((Boolean)member.getValue());
                    break;
                }
                case "coordinator": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCoordinator(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "members": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<MemberDescription> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new MemberDescription((JsonObject)item));
                        }
                    });
                    obj.setMembers(list);
                    break;
                }
                case "partitionAssignor": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPartitionAssignor((String)member.getValue());
                    break;
                }
                case "state": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setState(ConsumerGroupState.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "authorizedOperations": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<MemberDescription> list = new LinkedHashSet();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((MemberDescription)AclOperation.valueOf((String)((String)item)));
                        }
                    });
                    obj.setAuthorizedOperations((Set<AclOperation>)((Object)list));
                }
            }
        }
    }

    static void toJson(ConsumerGroupDescription obj, JsonObject json) {
        ConsumerGroupDescriptionConverter.toJson(obj, json.getMap());
    }

    static void toJson(ConsumerGroupDescription obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getGroupId() != null) {
            json.put("groupId", obj.getGroupId());
        }
        json.put("simpleConsumerGroup", obj.isSimpleConsumerGroup());
        if (obj.getCoordinator() != null) {
            json.put("coordinator", obj.getCoordinator().toJson());
        }
        if (obj.getMembers() != null) {
            array = new JsonArray();
            obj.getMembers().forEach(item -> array.add((Object)item.toJson()));
            json.put("members", array);
        }
        if (obj.getPartitionAssignor() != null) {
            json.put("partitionAssignor", obj.getPartitionAssignor());
        }
        if (obj.getState() != null) {
            json.put("state", obj.getState().name());
        }
        if (obj.getAuthorizedOperations() != null) {
            array = new JsonArray();
            obj.getAuthorizedOperations().forEach(item -> array.add((Object)item.name()));
            json.put("authorizedOperations", array);
        }
    }
}

