/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.consumer;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.ReadStream;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import io.vertx.kafka.client.consumer.KafkaConsumerRecords;
import io.vertx.kafka.client.consumer.KafkaReadStream;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import io.vertx.kafka.client.consumer.OffsetAndTimestamp;
import io.vertx.kafka.client.consumer.impl.KafkaConsumerImpl;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.serialization.Deserializer;

@VertxGen
public interface KafkaConsumer<K, V>
extends ReadStream<KafkaConsumerRecord<K, V>> {
    @GenIgnore(value={"permitted-type"})
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Consumer<K, V> consumer) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, consumer);
        return new KafkaConsumerImpl<K, V>(stream);
    }

    @GenIgnore(value={"permitted-type"})
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Consumer<K, V> consumer, KafkaClientOptions options) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, consumer, options);
        return new KafkaConsumerImpl<K, V>(stream);
    }

    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Map<String, String> config) {
        KafkaReadStream stream = KafkaReadStream.create(vertx, new HashMap<String, Object>(config));
        return new KafkaConsumerImpl(stream).registerCloseHook();
    }

    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Map<String, String> config, Class<K> keyType, Class<V> valueType) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, new HashMap<String, Object>(config), keyType, valueType);
        return new KafkaConsumerImpl<K, V>(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Map<String, String> config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, new HashMap<String, Object>(config), keyDeserializer, valueDeserializer);
        return new KafkaConsumerImpl<K, V>(stream).registerCloseHook();
    }

    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, KafkaClientOptions options) {
        KafkaReadStream stream = KafkaReadStream.create(vertx, options);
        return new KafkaConsumerImpl(stream).registerCloseHook();
    }

    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, KafkaClientOptions options, Class<K> keyType, Class<V> valueType) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, options, keyType, valueType);
        return new KafkaConsumerImpl<K, V>(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, KafkaClientOptions options, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, options, keyDeserializer, valueDeserializer);
        return new KafkaConsumerImpl<K, V>(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Properties config) {
        KafkaReadStream stream = KafkaReadStream.create(vertx, config);
        return new KafkaConsumerImpl(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, config, keyType, valueType);
        return new KafkaConsumerImpl<K, V>(stream).registerCloseHook();
    }

    @GenIgnore
    public static <K, V> KafkaConsumer<K, V> create(Vertx vertx, Properties config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        KafkaReadStream<K, V> stream = KafkaReadStream.create(vertx, config, keyDeserializer, valueDeserializer);
        return new KafkaConsumerImpl<K, V>(stream).registerCloseHook();
    }

    @Fluent
    public KafkaConsumer<K, V> exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public KafkaConsumer<K, V> handler(Handler<KafkaConsumerRecord<K, V>> var1);

    @Fluent
    public KafkaConsumer<K, V> pause();

    @Fluent
    public KafkaConsumer<K, V> resume();

    public KafkaConsumer<K, V> fetch(long var1);

    @Fluent
    public KafkaConsumer<K, V> endHandler(Handler<Void> var1);

    public long demand();

    public Future<Void> subscribe(String var1);

    public Future<Void> subscribe(Set<String> var1);

    @GenIgnore(value={"permitted-type"})
    public Future<Void> subscribe(Pattern var1);

    public Future<Void> assign(TopicPartition var1);

    public Future<Void> assign(Set<TopicPartition> var1);

    public Future<Set<TopicPartition>> assignment();

    @GenIgnore
    public Future<Map<String, List<PartitionInfo>>> listTopics();

    public Future<Void> unsubscribe();

    public Future<Set<String>> subscription();

    public Future<Void> pause(TopicPartition var1);

    public Future<Void> pause(Set<TopicPartition> var1);

    public Future<Set<TopicPartition>> paused();

    public Future<Void> resume(TopicPartition var1);

    public Future<Void> resume(Set<TopicPartition> var1);

    @Fluent
    public KafkaConsumer<K, V> partitionsRevokedHandler(Handler<Set<TopicPartition>> var1);

    @Fluent
    public KafkaConsumer<K, V> partitionsAssignedHandler(Handler<Set<TopicPartition>> var1);

    public Future<Void> seek(TopicPartition var1, long var2);

    public Future<Void> seek(TopicPartition var1, OffsetAndMetadata var2);

    public Future<Void> seekToBeginning(TopicPartition var1);

    public Future<Void> seekToBeginning(Set<TopicPartition> var1);

    public Future<Void> seekToEnd(TopicPartition var1);

    public Future<Void> seekToEnd(Set<TopicPartition> var1);

    public Future<Void> commit();

    @GenIgnore
    public Future<Map<TopicPartition, OffsetAndMetadata>> commit(Map<TopicPartition, OffsetAndMetadata> var1);

    public Future<OffsetAndMetadata> committed(TopicPartition var1);

    public Future<List<PartitionInfo>> partitionsFor(String var1);

    @Fluent
    public KafkaConsumer<K, V> batchHandler(Handler<KafkaConsumerRecords<K, V>> var1);

    public Future<Void> close();

    public Future<Long> position(TopicPartition var1);

    @GenIgnore
    public Future<Map<TopicPartition, OffsetAndTimestamp>> offsetsForTimes(Map<TopicPartition, Long> var1);

    public Future<OffsetAndTimestamp> offsetsForTimes(TopicPartition var1, Long var2);

    @GenIgnore
    public Future<Map<TopicPartition, Long>> beginningOffsets(Set<TopicPartition> var1);

    public Future<Long> beginningOffsets(TopicPartition var1);

    @GenIgnore
    public Future<Map<TopicPartition, Long>> endOffsets(Set<TopicPartition> var1);

    public Future<Long> endOffsets(TopicPartition var1);

    @GenIgnore
    public KafkaReadStream<K, V> asStream();

    @GenIgnore
    public Consumer<K, V> unwrap();

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public KafkaConsumer<K, V> pollTimeout(Duration var1);

    @GenIgnore(value={"permitted-type"})
    public Future<KafkaConsumerRecords<K, V>> poll(Duration var1);
}

