/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class CloseHandler {
    private Closeable closeable;
    private Runnable closeableHookCleanup;
    private final BiConsumer<Long, Completable<Void>> close;

    public CloseHandler(BiConsumer<Long, Completable<Void>> close) {
        this.close = close;
    }

    public void registerCloseHook(VertxInternal vertx) {
        this.registerCloseHook(arg_0 -> ((VertxInternal)vertx).addCloseHook(arg_0), arg_0 -> ((VertxInternal)vertx).removeCloseHook(arg_0));
    }

    public void registerCloseHook(ContextInternal context) {
        this.registerCloseHook(arg_0 -> ((ContextInternal)context).addCloseHook(arg_0), arg_0 -> ((ContextInternal)context).removeCloseHook(arg_0));
    }

    private synchronized void registerCloseHook(Consumer<Closeable> addCloseHook, Consumer<Closeable> removeCloseHook) {
        if (this.closeable == null) {
            this.closeable = ar -> {
                CloseHandler closeHandler = this;
                synchronized (closeHandler) {
                    if (this.closeable == null) {
                        ar.succeed();
                        return;
                    }
                    this.closeable = null;
                }
                this.close.accept(0L, (Completable<Void>)ar);
            };
            this.closeableHookCleanup = () -> {
                CloseHandler closeHandler = this;
                synchronized (closeHandler) {
                    if (this.closeable != null) {
                        removeCloseHook.accept(this.closeable);
                        this.closeable = null;
                    }
                }
            };
            addCloseHook.accept(this.closeable);
        }
    }

    public synchronized void unregisterCloseHook() {
        if (this.closeableHookCleanup != null) {
            this.closeableHookCleanup.run();
        }
    }

    public void close() {
        this.unregisterCloseHook();
        this.close.accept(0L, (Completable<Void>)((Completable)(res, err) -> {}));
    }

    public void close(Completable<Void> completionHandler) {
        this.unregisterCloseHook();
        this.close.accept(0L, completionHandler);
    }

    public void close(long timeout, Completable<Void> completionHandler) {
        this.unregisterCloseHook();
        this.close.accept(timeout, completionHandler);
    }
}

