/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common.tracing;

import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.kafka.client.common.tracing.TraceContext;
import java.util.function.Function;

public enum TraceTags {
    SERVER_ADDRESS("server.address", q -> q.address),
    SERVER_PORT("server.port", q -> q.port),
    PEER_SERVICE("peer.service", q -> "kafka"),
    BUS_DESTINATION("messaging.destination.name", q -> q.topic);

    static final TagExtractor<TraceContext> TAG_EXTRACTOR;
    final String name;
    final Function<TraceContext, String> fn;

    private TraceTags(String name, Function<TraceContext, String> fn) {
        this.name = name;
        this.fn = fn;
    }

    static {
        TAG_EXTRACTOR = new TagExtractor<TraceContext>(){
            private final TraceTags[] TAGS = TraceTags.values();

            public int len(TraceContext obj) {
                return this.TAGS.length;
            }

            public String name(TraceContext obj, int index) {
                return this.TAGS[index].name;
            }

            public String value(TraceContext obj, int index) {
                return this.TAGS[index].fn.apply(obj);
            }
        };
    }
}

