/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import io.vertx.codegen.ClassKind;
import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.lang.groovy.GroovyLang;
import io.vertx.docgen.Coordinate;
import io.vertx.docgen.DocGenerator;
import java.beans.Introspector;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

public class GroovyDocGenerator
implements DocGenerator {
    private TypeInfo.Factory factory;
    private CodeTranslator translator;
    private ProcessingEnvironment env;

    public void init(ProcessingEnvironment processingEnv) {
        this.factory = new TypeInfo.Factory(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this.translator = new CodeTranslator(processingEnv);
        this.env = processingEnv;
    }

    public String getName() {
        return "groovy";
    }

    public String renderSource(ExecutableElement elt, String source) {
        GroovyLang lang = new GroovyLang();
        try {
            return this.translator.translate(elt, (Lang)lang);
        }
        catch (Exception e) {
            System.out.println("Cannot generate " + elt.getEnclosingElement().getSimpleName() + "#" + elt.getSimpleName() + " : " + e.getMessage());
            return "Code not translatable";
        }
    }

    public String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
        TypeInfo type = null;
        try {
            type = this.factory.create(elt.asType());
        }
        catch (Exception e) {
            System.out.println("Could not resolve doc link for type " + elt.getQualifiedName());
            return null;
        }
        if (type.getKind() == ClassKind.ENUM && ((TypeInfo.Class.Enum)type).isGen()) {
            String baselink = coordinate == null ? "../" : "../../" + coordinate.getArtifactId() + "/";
            return baselink + "enums.html#" + elt.getSimpleName().toString();
        }
        if (type.getKind() == ClassKind.DATA_OBJECT) {
            String baselink = coordinate == null ? "../" : "../../" + coordinate.getArtifactId() + "/";
            return baselink + "dataobjects.html#" + elt.getSimpleName().toString();
        }
        if (type.getKind() == ClassKind.API) {
            String baselink = "";
            if (coordinate != null) {
                baselink = "../../" + coordinate.getArtifactId() + "/groovy/";
            }
            TypeInfo.Class.Api api = (TypeInfo.Class.Api)type.getRaw();
            return baselink + "groovydoc/" + api.translateName("groovy").replace('.', '/') + ".html";
        }
        return null;
    }

    public String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt, coordinate);
        if (link != null) {
            if (link.contains("cheatsheet")) {
                link = link + '#' + Introspector.decapitalize(elt.getSimpleName().toString().substring(3));
            } else {
                String anchor = '#' + elt.getSimpleName().toString() + "(";
                TypeMirror type = elt.asType();
                ExecutableType methodType = (ExecutableType)this.env.getTypeUtils().erasure(type);
                List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
                for (int i = 0; i < parameterTypes.size(); ++i) {
                    if (i > 0) {
                        anchor = anchor + ",%20";
                    }
                    anchor = anchor + parameterTypes.get(i).toString();
                }
                anchor = anchor + ')';
                link = link + anchor;
            }
        }
        return link;
    }

    public String resolveLabel(Element elt, String defaultLabel) {
        TypeInfo type;
        if (elt.getKind() == ElementKind.METHOD && (type = this.factory.create(elt.getEnclosingElement().asType())).getKind() == ClassKind.DATA_OBJECT) {
            String name = elt.getSimpleName().toString();
            if (name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                name = Introspector.decapitalize(name.substring(3));
            }
            return name;
        }
        return defaultLabel;
    }

    public String resolveConstructorLink(ExecutableElement elt, Coordinate coordinate) {
        return "todo";
    }

    public String resolveFieldLink(VariableElement elt, Coordinate coordinate) {
        return "todo";
    }
}

