/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.lang.groovy.GroovyVerticle;
import io.vertx.lang.groovy.ScriptVerticle;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;

public class GroovyVerticleFactory
implements VerticleFactory,
GroovyObject {
    private static final String CONFIGURATION_PROPERTY = "vertx.groovy.compilerConfiguration";
    private static Logger log;
    private Vertx vertx;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GroovyVerticleFactory() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void init(Vertx vertx) {
        Vertx vertx2;
        this.vertx = vertx2 = vertx;
    }

    public String prefix() {
        return "groovy";
    }

    public boolean blockingCreate() {
        return true;
    }

    public Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
        String string;
        verticleName = string = VerticleFactory.removePrefix((String)verticleName);
        Object instance = null;
        CompilerConfiguration compilerConfig = this.createCompilerConfiguration(classLoader);
        if (verticleName.endsWith(".groovy")) {
            Object object;
            URL url = classLoader.getResource(verticleName);
            if (url == null) {
                File f = new File(verticleName);
                if (!f.isAbsolute()) {
                    File file;
                    f = file = new File(System.getProperty("user.dir"), verticleName);
                }
                if (f.exists() && f.isFile()) {
                    URL uRL;
                    url = uRL = f.toURI().toURL();
                }
            }
            if (url == null) {
                throw (Throwable)new IllegalStateException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Cannot find verticle script: ", (CharSequence)verticleName), (CharSequence)" on classpath"));
            }
            GroovyClassLoader gcl = new GroovyClassLoader(classLoader, compilerConfig);
            GroovyCodeSource gcs = new GroovyCodeSource(url);
            Class clazz = gcl.parseClass(gcs);
            instance = object = DefaultGroovyMethods.newInstance((Class)clazz);
        } else {
            Object object;
            Class<?> clazz = classLoader.loadClass(verticleName);
            instance = object = DefaultGroovyMethods.newInstance(clazz);
        }
        Object verticle = null;
        if (instance instanceof GroovyVerticle) {
            Verticle verticle2;
            verticle = verticle2 = ((GroovyVerticle)ScriptBytecodeAdapter.castToType((Object)instance, GroovyVerticle.class)).asJavaVerticle();
        } else if (instance instanceof Script) {
            ScriptVerticle scriptVerticle = new ScriptVerticle((Script)ScriptBytecodeAdapter.castToType((Object)instance, Script.class));
            verticle = scriptVerticle;
        } else if (instance instanceof Verticle) {
            Verticle verticle3;
            verticle = verticle3 = (Verticle)ScriptBytecodeAdapter.castToType((Object)instance, Verticle.class);
        } else {
            throw (Throwable)new Exception(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Class ", (CharSequence)instance.getClass().getName()), (CharSequence)" is not a Verticle"));
        }
        return verticle;
    }

    public void close() {
        Object var1_1 = null;
        this.vertx = (Vertx)ScriptBytecodeAdapter.castToType(var1_1, Vertx.class);
    }

    private CompilerConfiguration createCompilerConfiguration(ClassLoader cl) {
        Closure customizer = null;
        Properties properties = new Properties();
        URL url = this.findConfigurationResource(cl);
        if (url != null) {
            log.trace((Object)new GStringImpl(new Object[]{url}, new String[]{"Configuring groovy compiler with ", ""}));
            try {
                if (url.getFile().toLowerCase().endsWith(".groovy")) {
                    ConfigSlurper slurper = new ConfigSlurper();
                    slurper.setClassLoader(new GroovyClassLoader(cl));
                    ConfigObject cObject = slurper.parse(url);
                    Object c = cObject.remove((Object)"customizer");
                    if (c instanceof Closure) {
                        Closure closure;
                        customizer = closure = (Closure)ScriptBytecodeAdapter.castToType((Object)c, Closure.class);
                    }
                    properties.putAll((Map<?, ?>)cObject.toProperties());
                }
                InputStream stream = url.openStream();
                properties.load(stream);
            }
            catch (Exception e) {
                log.error((Object)new GStringImpl(new Object[]{url}, new String[]{"Error loading Groovy CompilerConfiguration properties from ", ""}), (Throwable)e);
            }
        } else {
            log.trace((Object)"No groovy configuration file found.");
        }
        CompilerConfiguration compilerCfg = new CompilerConfiguration(CompilerConfiguration.DEFAULT);
        if (properties.size() != 0) {
            compilerCfg.configure(properties);
        }
        if (customizer != null) {
            Object result = customizer.call((Object)compilerCfg);
            if (result instanceof CompilerConfiguration) {
                CompilerConfiguration compilerConfiguration;
                compilerCfg = compilerConfiguration = (CompilerConfiguration)ScriptBytecodeAdapter.castToType((Object)result, CompilerConfiguration.class);
            }
        }
        return compilerCfg;
    }

    private URL findConfigurationResource(ClassLoader cl) {
        block6: {
            String prop = System.getProperty(CONFIGURATION_PROPERTY);
            if (!(prop != null)) break block6;
            URL uRL = cl.getResource(prop);
            try {
                return uRL;
            }
            catch (SecurityException ignored) {
            }
        }
        URL url = cl.getResource("compilerConfiguration.groovy");
        if (url == null) {
            URL uRL;
            url = uRL = cl.getResource("compilerConfiguration.properties");
        }
        return url;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GroovyVerticleFactory.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger(GroovyVerticleFactory.class);
    }
}

