/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import groovy.lang.Binding;
import groovy.lang.MetaMethod;
import groovy.lang.Script;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;

public class ScriptVerticle
extends AbstractVerticle {
    private final Script script;
    private static final Class[] EMPTY_PARAMS = new Class[0];
    private static final Class[] FUTURE_PARAMS = new Class[]{Future.class};

    public ScriptVerticle(Script script) {
        this.script = script;
    }

    public void start(Future<Void> startFuture) throws Exception {
        Binding binding = this.script.getBinding();
        if (this.script.getBinding() == null) {
            binding = new Binding();
            this.script.setBinding(binding);
        }
        binding.setVariable("vertx", (Object)this.vertx);
        this.script.run();
        this.handleLifecycle("vertxStart", startFuture);
    }

    public void stop(Future<Void> stopFuture) throws Exception {
        this.handleLifecycle("vertxStop", stopFuture);
    }

    private void handleLifecycle(String methodName, Future<Void> future) {
        MetaMethod method = this.script.getMetaClass().getMetaMethod(methodName, (Object[])EMPTY_PARAMS);
        if (method != null) {
            if (method.isValidMethod(FUTURE_PARAMS)) {
                method.invoke((Object)this.script, new Object[]{future});
            } else if (method.isValidMethod(EMPTY_PARAMS)) {
                method.invoke((Object)this.script, (Object[])EMPTY_PARAMS);
                future.complete();
            }
        } else {
            future.complete();
        }
    }
}

