/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-js/context */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JContext = io.vertx.core.Context;

/**
 Represents the execution context of a Verticle.

 @class
*/
var Context = function(j_val) {

  var j_context = j_val;
  var that = this;

  /**

   @public
   @param action {function} 
   */
  this.runOnContext = function(action) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_context.runOnContext(action);
    } else utils.invalidArgs();
  };

  /**

   @public

   @return {string}
   */
  this.deploymentID = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_context.deploymentID();
    } else utils.invalidArgs();
  };

  /**

   @public

   @return {Object}
   */
  this.config = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_context.config());
    } else utils.invalidArgs();
  };

  /**

   @public

   @return {Array.<string>}
   */
  this.processArgs = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_context.processArgs();
    } else utils.invalidArgs();
  };

  /**

   @public

   @return {boolean}
   */
  this.isEventLoopContext = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_context.isEventLoopContext();
    } else utils.invalidArgs();
  };

  /**

   @public

   @return {boolean}
   */
  this.isWorker = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_context.isWorker();
    } else utils.invalidArgs();
  };

  /**

   @public

   @return {boolean}
   */
  this.isMultiThreaded = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_context.isMultiThreaded();
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {string} 
   @return {Object}
   */
  this.get = function(key) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnTypeUnknown(j_context.get(key));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {string} 
   @param value {Object} 
   */
  this.put = function(key, value) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && true) {
      j_context.put(key, utils.convParamTypeUnknown(value));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {string} 
   @return {boolean}
   */
  this.remove = function(key) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_context.remove(key);
    } else utils.invalidArgs();
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_context;
};

// We export the Constructor function
module.exports = Context;