/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.js;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.spi.VerticleFactory;
import java.net.URL;
import java.util.Scanner;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class JSVerticleFactory
implements VerticleFactory {
    private Vertx vertx;
    private ScriptEngine engine;

    public void init(Vertx vertx) {
        this.vertx = vertx;
    }

    public String prefix() {
        return "js";
    }

    public Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
        this.init();
        return new JSVerticle(VerticleFactory.removePrefix((String)verticleName));
    }

    private synchronized void init() {
        if (this.engine == null) {
            ScriptEngineManager mgr = new ScriptEngineManager();
            this.engine = mgr.getEngineByName("nashorn");
            if (this.engine == null) {
                throw new IllegalStateException("Cannot find Nashorn JavaScript engine - maybe you are not running with Java 8 or later?");
            }
            URL url = this.getClass().getClassLoader().getResource("vertx-js/util/require.js");
            if (url == null) {
                throw new IllegalStateException("Cannot find vertx/util/require.js on classpath");
            }
            try (Scanner scanner = new Scanner(url.openStream(), "UTF-8").useDelimiter("\\A");){
                String requireJS = scanner.next();
                this.engine.put("javax.script.filename", "require.js");
                this.engine.eval(requireJS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load vertx/require.js", e);
            }
            try {
                this.engine.put("__jvertx", this.vertx);
                this.engine.put("__engine", this.engine);
                this.engine.eval("var Vertx = require('vertx-js/vertx'); var vertx = new Vertx(__jvertx); var console = require('vertx-js/util/console');");
                this.engine.eval("var setTimeout = function(callback,delay) { return vertx.setTimer(delay, callback); };");
                this.engine.eval("var clearTimeout = function(id) { vertx.cancelTimer(id); };");
                this.engine.eval("var setInterval = function(callback, delay) { return vertx.setPeriodic(delay, callback); };");
                this.engine.eval("var clearInterval = clearTimeout;");
                this.engine.eval("var parent = this;");
            }
            catch (ScriptException e) {
                throw new IllegalStateException("Failed to eval: " + e.getMessage(), e);
            }
        }
    }

    public class JSVerticle
    extends AbstractVerticle {
        private static final String VERTX_STOP_FUNCTION = "vertxStop";
        private final String verticleName;
        private ScriptObjectMirror exports;
        private boolean asyncStart;
        private boolean asyncStop;
        private Future<Void> startFuture;
        private Future<Void> stopFuture;

        private JSVerticle(String verticleName) {
            this.verticleName = verticleName;
        }

        public void start(Future<Void> startFuture) throws Exception {
            JSVerticleFactory.this.engine.put("__verticle", (Object)this);
            this.exports = (ScriptObjectMirror)JSVerticleFactory.this.engine.eval("require('" + this.verticleName + "');");
            if (this.asyncStart) {
                this.startFuture = startFuture;
            } else {
                startFuture.complete();
            }
        }

        public void stop(Future<Void> stopFuture) throws Exception {
            if (!this.exports.getMember(VERTX_STOP_FUNCTION).toString().equals("undefined")) {
                this.exports.callMember(VERTX_STOP_FUNCTION, new Object[0]);
                if (this.asyncStop) {
                    this.stopFuture = stopFuture;
                } else {
                    stopFuture.complete();
                }
            } else {
                stopFuture.complete();
            }
        }

        public void started(boolean started) {
            if (this.startFuture != null) {
                if (started) {
                    this.startFuture.complete();
                }
            } else if (!started) {
                this.asyncStart = true;
            }
        }

        public void stopped(boolean stopped) {
            if (this.stopFuture != null) {
                if (stopped) {
                    this.stopFuture.complete();
                }
            } else if (!stopped) {
                this.asyncStop = true;
            }
        }
    }
}

