/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-js/http_client */
var utils = require('vertx-js/util/utils');
var HttpClientRequest = require('vertx-js/http_client_request');
var HttpClientResponse = require('vertx-js/http_client_response');
var Measured = require('vertx-js/measured');
var WebSocketStream = require('vertx-js/web_socket_stream');
var MultiMap = require('vertx-js/multi_map');
var WebSocket = require('vertx-js/web_socket');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JHttpClient = io.vertx.core.http.HttpClient;

/**
 An HTTP client that maintains a pool of connections to a specific host, at a specific port. The client supports
 pipelining of requests.<p>
 @class
*/
var HttpClient = function(j_val) {

  var j_httpClient = j_val;
  var that = this;
  Measured.call(this, j_val);

  /**
   The metric base name

   @public

   @return {string}
   */
  this.metricBaseName = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_httpClient.metricBaseName();
    } else utils.invalidArgs();
  };

  /**
   Will return the metrics that correspond with this measured object.

   @public

   @return {Array.<string>}
   */
  this.metrics = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_httpClient.metrics());
    } else utils.invalidArgs();
  };

  /**

   @public
   @param method {Object} 
   @param absoluteURI {string} 
   @return {HttpClientRequest}
   */
  this.request = function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      return new HttpClientRequest(j_httpClient.request(io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1]));
    }  else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      return new HttpClientRequest(j_httpClient.request(io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1], function(jVal) {
      __args[2](new HttpClientResponse(jVal));
    }));
    }  else if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] ==='number' && typeof __args[2] === 'string' && typeof __args[3] === 'string') {
      return new HttpClientRequest(j_httpClient.request(io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1], __args[2], __args[3]));
    }  else if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] ==='number' && typeof __args[2] === 'string' && typeof __args[3] === 'string' && typeof __args[4] === 'function') {
      return new HttpClientRequest(j_httpClient.request(io.vertx.core.http.HttpMethod.valueOf(__args[0]), __args[1], __args[2], __args[3], function(jVal) {
      __args[4](new HttpClientResponse(jVal));
    }));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param port {number} 
   @param host {string} 
   @param requestURI {string} 
   @return {WebSocketStream}
   */
  this.websocket = function() {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return new WebSocketStream(j_httpClient.websocket(__args[0], __args[1], __args[2]));
    }  else if (__args.length === 4 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'object' && __args[3]._jdel) {
      return new WebSocketStream(j_httpClient.websocket(__args[0], __args[1], __args[2], __args[3]._jdel));
    }  else if (__args.length === 5 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'string') {
      return new WebSocketStream(j_httpClient.websocket(__args[0], __args[1], __args[2], __args[3]._jdel, io.vertx.core.http.WebsocketVersion.valueOf(__args[4])));
    }  else if (__args.length === 6 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'string' && typeof __args[5] === 'string') {
      return new WebSocketStream(j_httpClient.websocket(__args[0], __args[1], __args[2], __args[3]._jdel, io.vertx.core.http.WebsocketVersion.valueOf(__args[4]), __args[5]));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param port {number} 
   @param host {string} 
   @param requestURI {string} 
   @param wsConnect {function} 
   @return {HttpClient}
   */
  this.connectWebsocket = function() {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      return new HttpClient(j_httpClient.connectWebsocket(__args[0], __args[1], __args[2], function(jVal) {
      __args[3](new WebSocket(jVal));
    }));
    }  else if (__args.length === 5 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'function') {
      return new HttpClient(j_httpClient.connectWebsocket(__args[0], __args[1], __args[2], __args[3]._jdel, function(jVal) {
      __args[4](new WebSocket(jVal));
    }));
    }  else if (__args.length === 6 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'string' && typeof __args[5] === 'function') {
      return new HttpClient(j_httpClient.connectWebsocket(__args[0], __args[1], __args[2], __args[3]._jdel, io.vertx.core.http.WebsocketVersion.valueOf(__args[4]), function(jVal) {
      __args[5](new WebSocket(jVal));
    }));
    }  else if (__args.length === 7 && typeof __args[0] ==='number' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'string' && typeof __args[5] === 'string' && typeof __args[6] === 'function') {
      return new HttpClient(j_httpClient.connectWebsocket(__args[0], __args[1], __args[2], __args[3]._jdel, io.vertx.core.http.WebsocketVersion.valueOf(__args[4]), __args[5], function(jVal) {
      __args[6](new WebSocket(jVal));
    }));
    } else utils.invalidArgs();
  };

  /**
   Close the HTTP client. This will cause any pooled HTTP connections to be closed.

   @public

   */
  this.close = function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_httpClient.close();
    } else utils.invalidArgs();
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_httpClient;
};

// We export the Constructor function
module.exports = HttpClient;