/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-js/local_map */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JLocalMap = io.vertx.core.shareddata.LocalMap;

/**

 @class
*/
var LocalMap = function(j_val) {

  var j_localMap = j_val;
  var that = this;

  /**

   @public
   @param key {Object} 
   @return {Object}
   */
  this.get = function(key) {
    var __args = arguments;
    if (__args.length === 1 && true) {
      return utils.convReturnTypeUnknown(j_localMap.get(utils.convParamTypeUnknown(key)));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {Object} 
   @param value {Object} 
   @return {Object}
   */
  this.put = function(key, value) {
    var __args = arguments;
    if (__args.length === 2 && true && true) {
      return utils.convReturnTypeUnknown(j_localMap.put(utils.convParamTypeUnknown(key), utils.convParamTypeUnknown(value)));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {Object} 
   @return {Object}
   */
  this.remove = function(key) {
    var __args = arguments;
    if (__args.length === 1 && true) {
      return utils.convReturnTypeUnknown(j_localMap.remove(utils.convParamTypeUnknown(key)));
    } else utils.invalidArgs();
  };

  /**

   @public

   */
  this.clear = function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_localMap.clear();
    } else utils.invalidArgs();
  };

  /**

   @public

   @return {number}
   */
  this.size = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_localMap.size();
    } else utils.invalidArgs();
  };

  /**

   @public

   @return {boolean}
   */
  this.isEmpty = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_localMap.isEmpty();
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {Object} 
   @param value {Object} 
   @return {Object}
   */
  this.putIfAbsent = function(key, value) {
    var __args = arguments;
    if (__args.length === 2 && true && true) {
      return utils.convReturnTypeUnknown(j_localMap.putIfAbsent(utils.convParamTypeUnknown(key), utils.convParamTypeUnknown(value)));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {Object} 
   @param value {Object} 
   @return {boolean}
   */
  this.removeIfPresent = function(key, value) {
    var __args = arguments;
    if (__args.length === 2 && true && true) {
      return j_localMap.removeIfPresent(utils.convParamTypeUnknown(key), utils.convParamTypeUnknown(value));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {Object} 
   @param oldValue {Object} 
   @param newValue {Object} 
   @return {boolean}
   */
  this.replaceIfPresent = function(key, oldValue, newValue) {
    var __args = arguments;
    if (__args.length === 3 && true && true && true) {
      return j_localMap.replaceIfPresent(utils.convParamTypeUnknown(key), utils.convParamTypeUnknown(oldValue), utils.convParamTypeUnknown(newValue));
    } else utils.invalidArgs();
  };

  /**

   @public
   @param key {Object} 
   @param value {Object} 
   @return {Object}
   */
  this.replace = function(key, value) {
    var __args = arguments;
    if (__args.length === 2 && true && true) {
      return utils.convReturnTypeUnknown(j_localMap.replace(utils.convParamTypeUnknown(key), utils.convParamTypeUnknown(value)));
    } else utils.invalidArgs();
  };

  /**

   @public

   */
  this.close = function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_localMap.close();
    } else utils.invalidArgs();
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_localMap;
};

// We export the Constructor function
module.exports = LocalMap;