/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.js;

import io.vertx.codegen.Case;
import io.vertx.codegen.ClassKind;
import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.JavaScriptLang;
import io.vertx.codetrans.Lang;
import io.vertx.docgen.Coordinate;
import io.vertx.docgen.DocGenerator;
import java.beans.Introspector;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class JSDocGenerator
implements DocGenerator {
    private TypeInfo.Factory factory;
    private CodeTranslator translator;
    private ProcessingEnvironment env;

    public void init(ProcessingEnvironment processingEnv) {
        this.factory = new TypeInfo.Factory(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this.translator = new CodeTranslator(processingEnv);
        this.env = processingEnv;
    }

    public String getName() {
        return "js";
    }

    public String renderSource(ExecutableElement elt, String source) {
        JavaScriptLang lang = new JavaScriptLang();
        try {
            return this.translator.translate(elt, (Lang)lang);
        }
        catch (Exception e) {
            System.out.println("Cannot generate " + elt.getEnclosingElement().getSimpleName() + "#" + elt.getSimpleName() + " : " + e.getMessage());
            return "Code not translatable";
        }
    }

    public String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
        TypeInfo type = this.factory.create(elt.asType());
        if (type.getKind() == ClassKind.DATA_OBJECT) {
            String baselink = coordinate == null ? "../" : "../../" + coordinate.getArtifactId() + "/";
            return baselink + "cheatsheet/" + elt.getSimpleName().toString() + ".html";
        }
        if (type.getKind() == ClassKind.API) {
            String baselink = "";
            if (coordinate != null) {
                baselink = "../../" + coordinate.getArtifactId() + "/js/";
            }
            return baselink + "jsdoc/" + Case.SNAKE.format((Iterable)Case.CAMEL.parse(elt.getSimpleName().toString())) + "-" + elt.getSimpleName() + ".html";
        }
        return null;
    }

    public String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
        TypeElement typeElt = (TypeElement)elt.getEnclosingElement();
        String link = this.resolveTypeLink(typeElt, coordinate);
        if (link != null) {
            link = link.contains("cheatsheet") ? link + '#' + Introspector.decapitalize(elt.getSimpleName().toString().substring(3)) : link + '#' + elt.getSimpleName();
        }
        return link;
    }

    public String resolveLabel(Element elt, String defaultLabel) {
        TypeInfo type;
        if (elt.getKind() == ElementKind.METHOD && (type = this.factory.create(elt.getEnclosingElement().asType())).getKind() == ClassKind.DATA_OBJECT) {
            String name = elt.getSimpleName().toString();
            if (name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                name = Introspector.decapitalize(name.substring(3));
            }
            return name;
        }
        return defaultLabel;
    }

    public String resolveConstructorLink(ExecutableElement elt, Coordinate coordinate) {
        return "todo";
    }

    public String resolveFieldLink(VariableElement elt, Coordinate coordinate) {
        return "todo";
    }
}

