/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.js;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.lang.js.ClasspathFileResolver;
import java.net.URL;
import java.util.Scanner;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class JSVerticleFactory
implements VerticleFactory {
    public static final String DISABLE_NODEJS_PROCESS_ENV_PROP_NAME = "vertx.disableNodeJSProcessENV";
    private static final boolean ADD_NODEJS_PROCESS_ENV;
    private static final String JVM_NPM = "vertx-js/util/jvm-npm.js";
    private Vertx vertx;
    private ScriptEngine engine;
    private ScriptObjectMirror futureJSClass;

    public void init(Vertx vertx) {
        this.vertx = vertx;
    }

    public String prefix() {
        return "js";
    }

    public Verticle createVerticle(String verticleName, ClassLoader classLoader) throws Exception {
        this.init();
        return new JSVerticle(VerticleFactory.removePrefix((String)verticleName));
    }

    private synchronized void init() {
        if (this.engine == null) {
            ScriptEngineManager mgr = new ScriptEngineManager();
            this.engine = mgr.getEngineByName("nashorn");
            if (this.engine == null) {
                throw new IllegalStateException("Cannot find Nashorn JavaScript engine - maybe you are not running with Java 8 or later?");
            }
            URL url = this.getClass().getClassLoader().getResource(JVM_NPM);
            if (url == null) {
                throw new IllegalStateException("Cannot find vertx-js/util/jvm-npm.js on classpath");
            }
            try (Scanner scanner = new Scanner(url.openStream(), "UTF-8").useDelimiter("\\A");){
                String jvmNpm = scanner.next();
                String jvmNpmPath = ClasspathFileResolver.resolveFilename(JVM_NPM);
                jvmNpm = jvmNpm + "\n//# sourceURL=" + jvmNpmPath;
                this.engine.eval(jvmNpm);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            try {
                this.futureJSClass = (ScriptObjectMirror)this.engine.eval("require('vertx-js/future');");
                this.engine.put("__jvertx", this.vertx);
                String globs = "var Vertx = require('vertx-js/vertx'); var vertx = new Vertx(__jvertx); var console = require('vertx-js/util/console');var setTimeout = function(callback,delay) { return vertx.setTimer(delay, callback); };var clearTimeout = function(id) { vertx.cancelTimer(id); };var setInterval = function(callback, delay) { return vertx.setPeriodic(delay, callback); };var clearInterval = clearTimeout;var parent = this; var global = this;";
                if (ADD_NODEJS_PROCESS_ENV) {
                    globs = globs + "var process = {}; process.env=java.lang.System.getenv();";
                }
                this.engine.eval(globs);
            }
            catch (ScriptException e) {
                throw new IllegalStateException("Failed to eval: " + e.getMessage(), e);
            }
        }
    }

    static {
        ClasspathFileResolver.init();
        ADD_NODEJS_PROCESS_ENV = System.getProperty(DISABLE_NODEJS_PROCESS_ENV_PROP_NAME) == null;
    }

    public class JSVerticle
    extends AbstractVerticle {
        private static final String VERTX_START_FUNCTION = "vertxStart";
        private static final String VERTX_START_ASYNC_FUNCTION = "vertxStartAsync";
        private static final String VERTX_STOP_FUNCTION = "vertxStop";
        private static final String VERTX_STOP_ASYNC_FUNCTION = "vertxStopAsync";
        private final String verticleName;
        private ScriptObjectMirror exports;

        private JSVerticle(String verticleName) {
            this.verticleName = verticleName;
        }

        private boolean functionExists(String functionName) {
            Object som = this.exports.getMember(functionName);
            return som != null && !som.toString().equals("undefined");
        }

        public void start(Future<Void> startFuture) throws Exception {
            this.exports = (ScriptObjectMirror)JSVerticleFactory.this.engine.eval("require.noCache('" + this.verticleName + "', null, true);");
            if (this.functionExists(VERTX_START_FUNCTION)) {
                this.exports.callMember(VERTX_START_FUNCTION, new Object[0]);
                startFuture.complete();
            } else if (this.functionExists(VERTX_START_ASYNC_FUNCTION)) {
                Object wrappedFuture = JSVerticleFactory.this.futureJSClass.newObject(new Object[]{startFuture});
                this.exports.callMember(VERTX_START_ASYNC_FUNCTION, new Object[]{wrappedFuture});
            } else {
                startFuture.complete();
            }
        }

        public void stop(Future<Void> stopFuture) throws Exception {
            if (this.functionExists(VERTX_STOP_FUNCTION)) {
                this.exports.callMember(VERTX_STOP_FUNCTION, new Object[0]);
                stopFuture.complete();
            } else if (this.functionExists(VERTX_STOP_ASYNC_FUNCTION)) {
                Object wrappedFuture = JSVerticleFactory.this.futureJSClass.newObject(new Object[]{stopFuture});
                this.exports.callMember(VERTX_STOP_ASYNC_FUNCTION, new Object[]{wrappedFuture});
            } else {
                stopFuture.complete();
            }
        }
    }
}

