/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-js/composite_future */
var utils = require('vertx-js/util/utils');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JCompositeFuture = io.vertx.core.CompositeFuture;

/**

 @class
*/
var CompositeFuture = function(j_val) {

  var j_compositeFuture = j_val;
  var that = this;
  Future.call(this, j_val);

  /**

   @public
   @param handler {function} 
   @return {CompositeFuture}
   */
  this.setHandler = function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_compositeFuture["setHandler(io.vertx.core.Handler)"](function(ar) {
      if (ar.succeeded()) {
        handler(utils.convReturnVertxGen(ar.result(), CompositeFuture), null);
      } else {
        handler(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns a cause of a wrapped future

   @public
   @param index {number} the wrapped future index 
   @return {todo}
   */
  this.cause = function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnThrowable(j_compositeFuture["cause(int)"](index));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if a wrapped future is succeeded

   @public
   @param index {number} the wrapped future index 
   @return {boolean}
   */
  this.succeeded = function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_compositeFuture["succeeded(int)"](index);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if a wrapped future is failed

   @public
   @param index {number} the wrapped future index 
   @return {boolean}
   */
  this.failed = function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_compositeFuture["failed(int)"](index);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if a wrapped future is completed

   @public
   @param index {number} the wrapped future index 
   @return {boolean}
   */
  this.isComplete = function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_compositeFuture["isComplete(int)"](index);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the result of a wrapped future

   @public
   @param index {number} the wrapped future index 
   @return {Object}
   */
  this.result = function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnTypeUnknown(j_compositeFuture["result(int)"](index));
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   @return the number of wrapped future

   @public

   @return {number}
   */
  this.size = function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_compositeFuture["size()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_compositeFuture;
};

/**
 Like {@link CompositeFuture#all} but with 6 futures.

 @memberof module:vertx-js/composite_future
 @param f1 {Future} 
 @param f2 {Future} 
 @param f3 {Future} 
 @param f4 {Future} 
 @param f5 {Future} 
 @param f6 {Future} 
 @return {CompositeFuture}
 */
CompositeFuture.all = function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
    return utils.convReturnVertxGen(JCompositeFuture["all(java.util.List)"](utils.convParamListVertxGen(__args[0])), CompositeFuture);
  }else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel), CompositeFuture);
  }else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel), CompositeFuture);
  }else if (__args.length === 4 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel), CompositeFuture);
  }else if (__args.length === 5 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel), CompositeFuture);
  }else if (__args.length === 6 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel && typeof __args[5] === 'object' && __args[5]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel, __args[5]._jdel), CompositeFuture);
  } else throw new TypeError('function invoked with invalid arguments');
};

/**
 Like {@link CompositeFuture#any} but with 6 futures.

 @memberof module:vertx-js/composite_future
 @param f1 {Future} 
 @param f2 {Future} 
 @param f3 {Future} 
 @param f4 {Future} 
 @param f5 {Future} 
 @param f6 {Future} 
 @return {CompositeFuture}
 */
CompositeFuture.any = function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
    return utils.convReturnVertxGen(JCompositeFuture["any(java.util.List)"](utils.convParamListVertxGen(__args[0])), CompositeFuture);
  }else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel), CompositeFuture);
  }else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel), CompositeFuture);
  }else if (__args.length === 4 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel), CompositeFuture);
  }else if (__args.length === 5 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel), CompositeFuture);
  }else if (__args.length === 6 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel && typeof __args[5] === 'object' && __args[5]._jdel) {
    return utils.convReturnVertxGen(JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel, __args[5]._jdel), CompositeFuture);
  } else throw new TypeError('function invoked with invalid arguments');
};

// We export the Constructor function
module.exports = CompositeFuture;