/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.js;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ClasspathFileResolver {
    private static List<String> sourceDirs = Arrays.asList("src/main/resources", "src/test/resources");
    private static List<File> sourceDirFiles;
    private static boolean enabled;
    private static File DEBUG_JS_SOURCE_DIR;

    public static void init() {
        sourceDirFiles = new ArrayList<File>(sourceDirs.size());
        for (String dir : sourceDirs) {
            File f = new File(dir);
            if (!f.exists()) continue;
            enabled = true;
            sourceDirFiles.add(f);
        }
        if (enabled) {
            if (DEBUG_JS_SOURCE_DIR.exists()) {
                Vertx vertx = Vertx.vertx();
                CountDownLatch latch = new CountDownLatch(1);
                vertx.fileSystem().deleteRecursive(DEBUG_JS_SOURCE_DIR.getAbsolutePath(), true, res -> {
                    if (res.failed()) {
                        res.cause().printStackTrace();
                    }
                    latch.countDown();
                });
                try {
                    latch.await(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                vertx.close();
            } else {
                DEBUG_JS_SOURCE_DIR.mkdirs();
            }
        }
    }

    public static String resolveFilename(String scriptName) {
        if (enabled) {
            block18: {
                for (File sourceDir : sourceDirFiles) {
                    File source = new File(sourceDir, scriptName);
                    if (!source.exists()) continue;
                    return source.getPath();
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                cl = cl == null ? ClasspathFileResolver.class.getClassLoader() : cl;
                URL url = cl.getResource(scriptName);
                if (url != null) {
                    try {
                        URI uri = url.toURI();
                        if (!uri.getScheme().equals("jar")) break block18;
                        File target = new File(DEBUG_JS_SOURCE_DIR, scriptName);
                        if (!target.exists()) {
                            target.getParentFile().mkdirs();
                            Path path = target.toPath();
                            try (InputStream is = url.openStream();){
                                Files.copy(is, path, new CopyOption[0]);
                            }
                        }
                        return target.getPath();
                    }
                    catch (Exception e) {
                        throw new VertxException((Throwable)e);
                    }
                }
            }
            return null;
        }
        return null;
    }

    static {
        DEBUG_JS_SOURCE_DIR = new File(".vertx/debug-js");
    }
}

