/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-cassandra-js/result_set */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JResultSet = Java.type('io.vertx.cassandra.ResultSet');

/**

 @class
*/
var ResultSet = function(j_val) {

  var j_resultSet = j_val;
  var that = this;

  /**

   @public

   @return {boolean}
   */
  this.isExhausted =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_resultSet["isExhausted()"]() ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean}
   */
  this.isFullyFetched =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_resultSet["isFullyFetched()"]() ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number}
   */
  this.getAvailableWithoutFetching =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_resultSet["getAvailableWithoutFetching()"]() ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} handler called when result is fetched 
   @return {ResultSet}
   */
  this.fetchMoreResults =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_resultSet["fetchMoreResults(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      }) ;
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean}
   */
  this.wasApplied =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_resultSet["wasApplied()"]() ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_resultSet;
};

ResultSet._jclass = utils.getJavaClass("io.vertx.cassandra.ResultSet");
ResultSet._jtype = {accept: function(obj) {
    return ResultSet._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ResultSet.prototype, {});
    ResultSet.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ResultSet._create = function(jdel) {var obj = Object.create(ResultSet.prototype, {});
  ResultSet.apply(obj, arguments);
  return obj;
}
module.exports = ResultSet;