/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-common-js/hashing_algorithm */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JHashingAlgorithm = Java.type('io.vertx.ext.auth.HashingAlgorithm');

/**
 Hashing Algorithm. A common interface to interact with any system provided algorithms.

 @class
*/
var HashingAlgorithm = function(j_val) {

  var j_hashingAlgorithm = j_val;
  var that = this;

  /**
   return the symbolic name for the algorithm

   @public

   @return {string} short id e.g.: sha512.
   */
  this.id =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_hashingAlgorithm["id()"]() ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   return the list of param names required for this algorithm.

   @public

   @return {Array.<string>} set of param names.
   */
  this.params =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_hashingAlgorithm["params()"]()) ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Should the encoded string use the default separator to split fields.

   @public

   @return {boolean} true by default.
   */
  this.needsSeparator =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_hashingAlgorithm["needsSeparator()"]() ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_hashingAlgorithm;
};

HashingAlgorithm._jclass = utils.getJavaClass("io.vertx.ext.auth.HashingAlgorithm");
HashingAlgorithm._jtype = {accept: function(obj) {
    return HashingAlgorithm._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(HashingAlgorithm.prototype, {});
    HashingAlgorithm.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
HashingAlgorithm._create = function(jdel) {var obj = Object.create(HashingAlgorithm.prototype, {});
  HashingAlgorithm.apply(obj, arguments);
  return obj;
}
module.exports = HashingAlgorithm;