/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-rabbitmq-js/envelope */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JEnvelope = Java.type('io.vertx.rabbitmq.Envelope');

/**

 @class
*/
var Envelope = function(j_val) {

  var j_envelope = j_val;
  var that = this;

  /**
   Get the delivery tag included in this parameter envelope

   @public

   @return {number} the delivery tag
   */
  this.deliveryTag =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cacheddeliveryTag == null) {
        that.cacheddeliveryTag = j_envelope["deliveryTag()"]();
      }
      return that.cacheddeliveryTag;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the redelivery flag included in this parameter envelope. This is a
   hint as to whether this message may have been delivered before (but not
   acknowledged). If the flag is not set, the message definitely has not
   been delivered before. If it is set, it may have been delivered before.

   @public

   @return {boolean} the redelivery flag
   */
  this.isRedelivery =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedisRedelivery == null) {
        that.cachedisRedelivery = j_envelope["isRedelivery()"]();
      }
      return that.cachedisRedelivery;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the name of the exchange included in this parameter envelope

   @public

   @return {string} the exchange
   */
  this.exchange =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedexchange == null) {
        that.cachedexchange = j_envelope["exchange()"]();
      }
      return that.cachedexchange;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the routing key included in this parameter envelope

   @public

   @return {string} the routing key
   */
  this.routingKey =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedroutingKey == null) {
        that.cachedroutingKey = j_envelope["routingKey()"]();
      }
      return that.cachedroutingKey;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_envelope;
};

Envelope._jclass = utils.getJavaClass("io.vertx.rabbitmq.Envelope");
Envelope._jtype = {accept: function(obj) {
    return Envelope._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Envelope.prototype, {});
    Envelope.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Envelope._create = function(jdel) {var obj = Object.create(Envelope.prototype, {});
  Envelope.apply(obj, arguments);
  return obj;
}
module.exports = Envelope;