/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-client-js/response_predicate_result */
var utils = require('vertx-js/util/utils');
var HttpResponse = require('vertx-web-client-js/http_response');
var Buffer = require('vertx-js/buffer');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JResponsePredicateResult = Java.type('io.vertx.ext.web.client.predicate.ResponsePredicateResult');

/**

 @class
*/
var ResponsePredicateResult = function(j_val) {

  var j_responsePredicateResult = j_val;
  var that = this;

  /**
   Whether the result is a success or failure.

   @public

   @return {boolean} <code>true</code> if the {@link ResponsePredicate} was applied successfully, false otherwise
   */
  this.succeeded =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_responsePredicateResult["succeeded()"]() ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   The failure message. May be <code>null</code>.

   @public

   @return {string}
   */
  this.message =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_responsePredicateResult["message()"]() ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   The  which has been tested.

   @public

   @return {HttpResponse} <code>null</code> after the result has been created, or the tested response for converters created with {@link ErrorConverter#createFullBody}
   */
  this.response =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(HttpResponse, j_responsePredicateResult["response()"](), Buffer._jtype) ;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_responsePredicateResult;
};

ResponsePredicateResult._jclass = utils.getJavaClass("io.vertx.ext.web.client.predicate.ResponsePredicateResult");
ResponsePredicateResult._jtype = {accept: function(obj) {
    return ResponsePredicateResult._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ResponsePredicateResult.prototype, {});
    ResponsePredicateResult.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ResponsePredicateResult._create = function(jdel) {var obj = Object.create(ResponsePredicateResult.prototype, {});
  ResponsePredicateResult.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-web-client-js/response_predicate_result

 @return {ResponsePredicateResult} a successful result
 */
ResponsePredicateResult.success =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(ResponsePredicateResult, JResponsePredicateResult["success()"]()) ;
  } else throw new TypeError('function invoked with invalid arguments');
};

/**
 Creates a failed result.

 @memberof module:vertx-web-client-js/response_predicate_result
 @param message {string} the failure description 
 @return {ResponsePredicateResult}
 */
ResponsePredicateResult.failure =  function(message) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(ResponsePredicateResult, JResponsePredicateResult["failure(java.lang.String)"](message)) ;
  } else throw new TypeError('function invoked with invalid arguments');
};

module.exports = ResponsePredicateResult;