/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-unit-js/completion */
var utils = require('vertx-js/util/utils');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JCompletion = Java.type('io.vertx.ext.unit.Completion');

/**
 A completion object that emits completion notifications either <i>succeeded</i> or <i>failed</i>.

 @class
*/
var Completion = function(j_val, j_arg_0) {

  var j_completion = j_val;
  var that = this;
  var j_T = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;
  var __super_resolve = this.resolve;
  var __super_isCompleted = this.isCompleted;
  var __super_isSucceeded = this.isSucceeded;
  var __super_isFailed = this.isFailed;
  var __super_handler = this.handler;
  var __super_await = this.await;
  var __super_await = this.await;
  var __super_awaitSuccess = this.awaitSuccess;
  var __super_awaitSuccess = this.awaitSuccess;
  /**
   Completes the future upon completion, otherwise fails it.

   @public
   @param future {Future} the future to resolve 
   */
  this.resolve =  function(future) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_completion["resolve(io.vertx.core.Future)"](__args[0]._jdel);
    } else if (typeof __super_resolve != 'undefined') {
      return __super_resolve.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} true if this completion is completed
   */
  this.isCompleted =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_completion["isCompleted()"]() ;
    } else if (typeof __super_isCompleted != 'undefined') {
      return __super_isCompleted.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} true if this completion is completed and succeeded
   */
  this.isSucceeded =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_completion["isSucceeded()"]() ;
    } else if (typeof __super_isSucceeded != 'undefined') {
      return __super_isSucceeded.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} true if the this completion is completed and failed
   */
  this.isFailed =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_completion["isFailed()"]() ;
    } else if (typeof __super_isFailed != 'undefined') {
      return __super_isFailed.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Completion handler to receive a completion signal when this completions completes.

   @public
   @param completionHandler {function} the completion handler 
   */
  this.handler =  function(completionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_completion["handler(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](j_T.wrap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_handler != 'undefined') {
      return __super_handler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Cause the current thread to wait until this completion completes with a configurable timeout.<p/>

   If completion times out or the current thread is interrupted, an exception will be thrown.

   @public
   @param timeoutMillis {number} the timeout in milliseconds 
   */
  this.await =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_completion["await()"]();
    } else if (__args.length === 1 && typeof __args[0] ==='number') {
      j_completion["await(long)"](__args[0]);
    } else if (typeof __super_await != 'undefined') {
      return __super_await.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Cause the current thread to wait until this completion completes and succeeds with a configurable timeout.<p/>

   If completion times out or the current thread is interrupted or the suite fails, an exception will be thrown.

   @public
   @param timeoutMillis {number} the timeout in milliseconds 
   */
  this.awaitSuccess =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_completion["awaitSuccess()"]();
    } else if (__args.length === 1 && typeof __args[0] ==='number') {
      j_completion["awaitSuccess(long)"](__args[0]);
    } else if (typeof __super_awaitSuccess != 'undefined') {
      return __super_awaitSuccess.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_completion;
};

Completion._jclass = utils.getJavaClass("io.vertx.ext.unit.Completion");
Completion._jtype = {accept: function(obj) {
    return Completion._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Completion.prototype, {});
    Completion.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Completion._create = function(jdel) {var obj = Object.create(Completion.prototype, {});
  Completion.apply(obj, arguments);
  return obj;
}
module.exports = Completion;