/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/transaction */
var utils = require('vertx-js/util/utils');
var SqlClient = require('vertx-sql-client-js/sql_client');
var RowSet = require('vertx-sql-client-js/row_set');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');
var Tuple = require('vertx-sql-client-js/tuple');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JTransaction = Java.type('io.vertx.sqlclient.Transaction');

/**
 A transaction that allows to control the transaction and receive events.

 @class
*/
var Transaction = function(j_val) {

  var j_transaction = j_val;
  var that = this;
  SqlClient.call(this, j_val);

  var __super_prepare = this.prepare;
  var __super_commit = this.commit;
  var __super_commit = this.commit;
  var __super_rollback = this.rollback;
  var __super_rollback = this.rollback;
  var __super_abortHandler = this.abortHandler;
  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedQuery = this.preparedQuery;
  var __super_preparedBatch = this.preparedBatch;
  var __super_close = this.close;
  /**
   Create a prepared query.

   @public
   @param sql {string} the sql 
   @param handler {function} the handler notified with the prepared query asynchronously 
   @return {Transaction}
   */
  this.prepare =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_transaction["prepare(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PreparedQuery, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_prepare != 'undefined') {
      return __super_prepare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link Transaction#commit} with an handler to be notified when the transaction commit has completed

   @public
   @param handler {function} 
   */
  this.commit =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_transaction["commit()"]();
    } else if (__args.length === 1 && typeof __args[0] === 'function') {
      j_transaction["commit(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_commit != 'undefined') {
      return __super_commit.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link Transaction#rollback} with an handler to be notified when the transaction rollback has completed

   @public
   @param handler {function} 
   */
  this.rollback =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_transaction["rollback()"]();
    } else if (__args.length === 1 && typeof __args[0] === 'function') {
      j_transaction["rollback(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_rollback != 'undefined') {
      return __super_rollback.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an handler to be called when the transaction is aborted.

   @public
   @param handler {function} the handler 
   @return {Transaction}
   */
  this.abortHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_transaction["abortHandler(io.vertx.core.Handler)"](__args[0]) ;
      return that;
    } else if (typeof __super_abortHandler != 'undefined') {
      return __super_abortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {Transaction}
   */
  this.query =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_transaction["query(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param arguments {Tuple} 
   @param handler {function} 
   @return {Transaction}
   */
  this.preparedQuery =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_transaction["preparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RowSet, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'function') {
      j_transaction["preparedQuery(java.lang.String,io.vertx.sqlclient.Tuple,io.vertx.core.Handler)"](__args[0], __args[1]._jdel, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(RowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param sql {string} 
   @param batch {Array.<Tuple>} 
   @param handler {function} 
   @return {Transaction}
   */
  this.preparedBatch =  function(sql, batch, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_transaction["preparedBatch(java.lang.String,java.util.List,io.vertx.core.Handler)"](__args[0], utils.convParamListVertxGen(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(RowSet, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_preparedBatch != 'undefined') {
      return __super_preparedBatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Rollback the transaction and release the associated resources.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_transaction["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_transaction;
};

Transaction._jclass = utils.getJavaClass("io.vertx.sqlclient.Transaction");
Transaction._jtype = {accept: function(obj) {
    return Transaction._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Transaction.prototype, {});
    Transaction.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Transaction._create = function(jdel) {var obj = Object.create(Transaction.prototype, {});
  Transaction.apply(obj, arguments);
  return obj;
}
module.exports = Transaction;