/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-templ-rocker-js/rocker_template_engine */
var utils = require('vertx-js/util/utils');
var TemplateEngine = require('vertx-web-common-js/template_engine');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JRockerTemplateEngine = Java.type('io.vertx.ext.web.templ.rocker.RockerTemplateEngine');

/**
 A template engine that uses the Rocker library.

 @class
*/
var RockerTemplateEngine = function(j_val) {

  var j_rockerTemplateEngine = j_val;
  var that = this;
  TemplateEngine.call(this, j_val);

  var __super_create = this.create;
  var __super_setExtension = this.setExtension;
  var __super_setMaxCacheSize = this.setMaxCacheSize;
  /**
   Set the extension for the engine

   @public
   @param extension {string} the extension 
   @return {RockerTemplateEngine} a reference to this for fluency
   */
  this.setExtension =  function(extension) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_rockerTemplateEngine["setExtension(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_setExtension != 'undefined') {
      return __super_setExtension.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the max cache size for the engine

   @public
   @param maxCacheSize {number} the maxCacheSize 
   @return {RockerTemplateEngine} a reference to this for fluency
   */
  this.setMaxCacheSize =  function(maxCacheSize) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_rockerTemplateEngine["setMaxCacheSize(int)"](__args[0]) ;
      return that;
    } else if (typeof __super_setMaxCacheSize != 'undefined') {
      return __super_setMaxCacheSize.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_rockerTemplateEngine;
};

RockerTemplateEngine._jclass = utils.getJavaClass("io.vertx.ext.web.templ.rocker.RockerTemplateEngine");
RockerTemplateEngine._jtype = {accept: function(obj) {
    return RockerTemplateEngine._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(RockerTemplateEngine.prototype, {});
    RockerTemplateEngine.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RockerTemplateEngine._create = function(jdel) {var obj = Object.create(RockerTemplateEngine.prototype, {});
  RockerTemplateEngine.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-web-templ-rocker-js/rocker_template_engine

 @return {RockerTemplateEngine} the engine
 */
RockerTemplateEngine.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(RockerTemplateEngine, JRockerTemplateEngine["create()"]()) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

RockerTemplateEngine.DEFAULT_MAX_CACHE_SIZE = JRockerTemplateEngine.DEFAULT_MAX_CACHE_SIZE;
RockerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION = JRockerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
module.exports = RockerTemplateEngine;