/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-js/composite_future */
var utils = require('vertx-js/util/utils');
var Future = require('vertx-js/future');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JCompositeFuture = Java.type('io.vertx.core.CompositeFuture');

/**

 @class
*/
var CompositeFuture = function(j_val) {

  var j_compositeFuture = j_val;
  var that = this;
  Future.call(this, j_val, CompositeFuture._jtype);

  var __super_complete = this.complete;
  var __super_tryComplete = this.tryComplete;
  var __super_result = this.result;
  var __super_flatMap = this.flatMap;
  var __super_compose = this.compose;
  var __super_compose = this.compose;
  var __super_map = this.map;
  var __super_completer = this.completer;
  var __super_recover = this.recover;
  var __super_otherwise = this.otherwise;
  var __super_otherwise = this.otherwise;
  var __super_otherwiseEmpty = this.otherwiseEmpty;
  var __super_all = this.all;
  var __super_all = this.all;
  var __super_all = this.all;
  var __super_all = this.all;
  var __super_all = this.all;
  var __super_all = this.all;
  var __super_any = this.any;
  var __super_any = this.any;
  var __super_any = this.any;
  var __super_any = this.any;
  var __super_any = this.any;
  var __super_any = this.any;
  var __super_join = this.join;
  var __super_join = this.join;
  var __super_join = this.join;
  var __super_join = this.join;
  var __super_join = this.join;
  var __super_join = this.join;
  var __super_setHandler = this.setHandler;
  var __super_complete = this.complete;
  var __super_tryComplete = this.tryComplete;
  var __super_cause = this.cause;
  var __super_succeeded = this.succeeded;
  var __super_failed = this.failed;
  var __super_isComplete = this.isComplete;
  var __super_resultAt = this.resultAt;
  var __super_size = this.size;
  /**
   Set this instance as result. Any handler will be called, if there is one, and the future will be marked as completed.

   @public

   */
  this.complete =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_compositeFuture["complete(io.vertx.core.CompositeFuture)"](__args[0]._jdel);
    } else if (__args.length === 0) {
      j_compositeFuture["complete()"]();
    } else if (typeof __super_complete != 'undefined') {
      return __super_complete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Try to set this instance as result. When it happens, any handler will be called, if there is one, and the future will be marked as completed.

   @public

   @return {boolean} false when the future is already completed
   */
  this.tryComplete =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return j_compositeFuture["tryComplete(io.vertx.core.CompositeFuture)"](__args[0]._jdel) ;
    } else if (__args.length === 0) {
      return j_compositeFuture["tryComplete()"]() ;
    } else if (typeof __super_tryComplete != 'undefined') {
      return __super_tryComplete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   The result of the operation. This will be null if the operation failed.

   @public

   @return {CompositeFuture} the result or null if the operation failed.
   */
  this.result =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(CompositeFuture, j_compositeFuture["result()"]()) ;
    } else if (typeof __super_result != 'undefined') {
      return __super_result.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Alias for {@link Future#compose}.

   @public
   @param mapper {function} 
   @return {Future}
   */
  this.flatMap =  function(mapper) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(Future, j_compositeFuture["flatMap(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnVertxGen(CompositeFuture, jVal));
        return jRet._jdel;
      }), undefined) ;
    } else if (typeof __super_flatMap != 'undefined') {
      return __super_flatMap.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Compose this future with a <code>successMapper</code> and <code>failureMapper</code> functions.<p>

   When this future (the one on which <code>compose</code> is called) succeeds, the <code>successMapper</code> will be called with
   the completed value and this mapper returns another future object. This returned future completion will complete
   the future returned by this method call.<p>

   When this future (the one on which <code>compose</code> is called) fails, the <code>failureMapper</code> will be called with
   the failure and this mapper returns another future object. This returned future completion will complete
   the future returned by this method call.<p>

   If any mapper function throws an exception, the returned future will be failed with this exception.<p>

   @public
   @param successMapper {function} the function mapping the success 
   @param failureMapper {function} the function mapping the failure 
   @return {Future} the composed future
   */
  this.compose =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(Future, j_compositeFuture["compose(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnVertxGen(CompositeFuture, jVal));
        return jRet._jdel;
      }), undefined) ;
    } else if (__args.length === 2 && typeof __args[0] === 'function' && typeof __args[1] === 'function') {
      return utils.convReturnVertxGen(Future, j_compositeFuture["compose(java.util.function.Function,java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnVertxGen(CompositeFuture, jVal));
        return jRet._jdel;
      }, function(jVal) {
        var jRet = __args[1](utils.convReturnThrowable(jVal));
        return jRet._jdel;
      }), undefined) ;
    } else if (typeof __super_compose != 'undefined') {
      return __super_compose.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Apply a <code>mapper</code> function on this future.<p>

   When this future succeeds, the <code>mapper</code> will be called with the completed value and this mapper
   returns a value. This value will complete the future returned by this method call.<p>

   If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>

   When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   will not be called.

   @public
   @param mapper {function} the mapper function 
   @return {Future} the mapped future
   */
  this.map =  function(mapper) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(Future, j_compositeFuture["map(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnVertxGen(CompositeFuture, jVal));
        return utils.convParamTypeUnknown(jRet);
      }), undefined) ;
    } else if (typeof __super_map != 'undefined') {
      return __super_map.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {function} an handler completing this future
   */
  this.completer =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedcompleter == null) {
        that.cachedcompleter = utils.convReturnHandlerAsyncResult(j_compositeFuture["completer()"](), function(result) { return result._jdel; });
      }
      return that.cachedcompleter;
    } else if (typeof __super_completer != 'undefined') {
      return __super_completer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Handles a failure of this Future by returning the result of another Future.
   If the mapper fails, then the returned future will be failed with this failure.

   @public
   @param mapper {function} A function which takes the exception of a failure and returns a new future. 
   @return {Future} A recovered future
   */
  this.recover =  function(mapper) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(Future, j_compositeFuture["recover(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnThrowable(jVal));
        return jRet._jdel;
      }), CompositeFuture._jtype) ;
    } else if (typeof __super_recover != 'undefined') {
      return __super_recover.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Map the failure of a future to a specific <code>value</code>.<p>

   When this future fails, this <code>value</code> will complete the future returned by this method call.<p>

   When this future succeeds, the result will be propagated to the returned future.

   @public
   @param value {CompositeFuture} the value that eventually completes the mapped future 
   @return {Future} the mapped future
   */
  this.otherwise =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(Future, j_compositeFuture["otherwise(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnThrowable(jVal));
        return jRet._jdel;
      }), CompositeFuture._jtype) ;
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(Future, j_compositeFuture["otherwise(io.vertx.core.CompositeFuture)"](__args[0]._jdel), CompositeFuture._jtype) ;
    } else if (typeof __super_otherwise != 'undefined') {
      return __super_otherwise.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Map the failure of a future to <code>null</code>.<p>

   This is a convenience for <code>future.otherwise((T) null)</code>.<p>

   When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>

   When this future succeeds, the result will be propagated to the returned future.

   @public

   @return {Future} the mapped future
   */
  this.otherwiseEmpty =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Future, j_compositeFuture["otherwiseEmpty()"](), CompositeFuture._jtype) ;
    } else if (typeof __super_otherwiseEmpty != 'undefined') {
      return __super_otherwiseEmpty.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {CompositeFuture}
   */
  this.setHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_compositeFuture["setHandler(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(CompositeFuture, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_setHandler != 'undefined') {
      return __super_setHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns a cause of a wrapped future

   @public
   @param index {number} the wrapped future index 
   @return {todo}
   */
  this.cause =  function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnThrowable(j_compositeFuture["cause(int)"](__args[0])) ;
    } else if (typeof __super_cause != 'undefined') {
      return __super_cause.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if a wrapped future is succeeded

   @public
   @param index {number} the wrapped future index 
   @return {boolean}
   */
  this.succeeded =  function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_compositeFuture["succeeded(int)"](__args[0]) ;
    } else if (typeof __super_succeeded != 'undefined') {
      return __super_succeeded.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if a wrapped future is failed

   @public
   @param index {number} the wrapped future index 
   @return {boolean}
   */
  this.failed =  function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_compositeFuture["failed(int)"](__args[0]) ;
    } else if (typeof __super_failed != 'undefined') {
      return __super_failed.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns true if a wrapped future is completed

   @public
   @param index {number} the wrapped future index 
   @return {boolean}
   */
  this.isComplete =  function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_compositeFuture["isComplete(int)"](__args[0]) ;
    } else if (typeof __super_isComplete != 'undefined') {
      return __super_isComplete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the result of a wrapped future

   @public
   @param index {number} the wrapped future index 
   @return {Object}
   */
  this.resultAt =  function(index) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnTypeUnknown(j_compositeFuture["resultAt(int)"](__args[0])) ;
    } else if (typeof __super_resultAt != 'undefined') {
      return __super_resultAt.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the number of wrapped future
   */
  this.size =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_compositeFuture["size()"]() ;
    } else if (typeof __super_size != 'undefined') {
      return __super_size.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_compositeFuture;
};

CompositeFuture._jclass = utils.getJavaClass("io.vertx.core.CompositeFuture");
CompositeFuture._jtype = {accept: function(obj) {
    return CompositeFuture._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(CompositeFuture.prototype, {});
    CompositeFuture.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
CompositeFuture._create = function(jdel) {var obj = Object.create(CompositeFuture.prototype, {});
  CompositeFuture.apply(obj, arguments);
  return obj;
}
/**
 Like {@link CompositeFuture#all} but with a list of futures.<p>

 When the list is empty, the returned future will be already completed.

 @memberof module:vertx-js/composite_future
 @param futures {Array.<Future>} 
 @return {CompositeFuture}
 */
CompositeFuture.all =  function() {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel)) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel)) ;
  } else if (__args.length === 4 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel)) ;
  } else if (__args.length === 5 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel)) ;
  } else if (__args.length === 6 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel && typeof __args[5] === 'object' && __args[5]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["all(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel, __args[5]._jdel)) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["all(java.util.List)"](utils.convParamListVertxGen(__args[0]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Like {@link CompositeFuture#any} but with a list of futures.<p>

 When the list is empty, the returned future will be already completed.

 @memberof module:vertx-js/composite_future
 @param futures {Array.<Future>} 
 @return {CompositeFuture}
 */
CompositeFuture.any =  function() {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel)) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel)) ;
  } else if (__args.length === 4 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel)) ;
  } else if (__args.length === 5 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel)) ;
  } else if (__args.length === 6 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel && typeof __args[5] === 'object' && __args[5]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["any(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel, __args[5]._jdel)) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["any(java.util.List)"](utils.convParamListVertxGen(__args[0]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Like {@link CompositeFuture#join} but with a list of futures.<p>

 When the list is empty, the returned future will be already completed.

 @memberof module:vertx-js/composite_future
 @param futures {Array.<Future>} 
 @return {CompositeFuture}
 */
CompositeFuture.join =  function() {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["join(io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel)) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["join(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel)) ;
  } else if (__args.length === 4 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["join(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel)) ;
  } else if (__args.length === 5 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["join(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel)) ;
  } else if (__args.length === 6 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'object' && __args[1]._jdel && typeof __args[2] === 'object' && __args[2]._jdel && typeof __args[3] === 'object' && __args[3]._jdel && typeof __args[4] === 'object' && __args[4]._jdel && typeof __args[5] === 'object' && __args[5]._jdel) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["join(io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future,io.vertx.core.Future)"](__args[0]._jdel, __args[1]._jdel, __args[2]._jdel, __args[3]._jdel, __args[4]._jdel, __args[5]._jdel)) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
    return utils.convReturnVertxGen(CompositeFuture, JCompositeFuture["join(java.util.List)"](utils.convParamListVertxGen(__args[0]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = CompositeFuture;