/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-redis-js/request */
var utils = require('vertx-js/util/utils');
var Buffer = require('vertx-js/buffer');
var Command = require('vertx-redis-js/command');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JRequest = Java.type('io.vertx.redis.client.Request');

/**
 Builder for REDIS requests that will be encoded according to the RESP protocol was introduced in Redis 1.2.
 Which became the standard way for talking with the Redis server in Redis 2.0.

 Redis <a href="https://redis.io/topics/protocol">protocol documentation</a> states:

 <blockquote>
     Clients send commands to a Redis server as a RESP Array of Bulk Strings.
 </blockquote>

 So all non String/Bulk types will be encoded to Bulk for convenience.

 @class
*/
var Request = function(j_val) {

  var j_request = j_val;
  var that = this;

  var __super_cmd = this.cmd;
  var __super_arg = this.arg;
  var __super_arg = this.arg;
  var __super_arg = this.arg;
  var __super_arg = this.arg;
  var __super_arg = this.arg;
  var __super_nullArg = this.nullArg;
  var __super_command = this.command;
  /**
   Adds a boolean encoded to string

   @public
   @param arg {boolean} 
   @return {Request} self
   */
  this.arg =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_request["arg(java.lang.String)"](__args[0]) ;
      return that;
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      j_request["arg(java.lang.String,java.lang.String)"](__args[0], __args[1]) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_request["arg(io.vertx.core.buffer.Buffer)"](__args[0]._jdel) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] ==='number') {
      j_request["arg(long)"](__args[0]) ;
      return that;
    } else if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_request["arg(boolean)"](__args[0]) ;
      return that;
    } else if (typeof __super_arg != 'undefined') {
      return __super_arg.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Adds a NULL encoded string

   @public

   @return {Request} self
   */
  this.nullArg =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_request["nullArg()"]() ;
      return that;
    } else if (typeof __super_nullArg != 'undefined') {
      return __super_nullArg.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the Command that is to be used by this request.

   @public

   @return {Command} the command.
   */
  this.command =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Command, j_request["command()"]()) ;
    } else if (typeof __super_command != 'undefined') {
      return __super_command.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_request;
};

Request._jclass = utils.getJavaClass("io.vertx.redis.client.Request");
Request._jtype = {accept: function(obj) {
    return Request._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Request.prototype, {});
    Request.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Request._create = function(jdel) {var obj = Object.create(Request.prototype, {});
  Request.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-redis-js/request
 @param command {Command} 
 @return {Request}
 */
Request.cmd =  function(command) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(Request, JRequest["cmd(io.vertx.redis.client.Command)"](__args[0]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = Request;