/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-js/multi_tenant_handler */
var utils = require('vertx-js/util/utils');
var RoutingContext = require('vertx-web-js/routing_context');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JMultiTenantHandler = Java.type('io.vertx.ext.web.handler.MultiTenantHandler');

/**
 A handler which selectively executes another handler if a precondition is met.

 There are cases where applications are build as multi tenant, in this cases one of the
 common tasks is to configure different authentication mechanisms for each tenant.

 This handler will allow registering any other handler and will only execute it if
 the precondition is met. There are 2 way of defining a precondition:

 <ul>
     <li>A http header value for example <pre>X-Tenant</pre></li>
     <li>A custom extractor function that can return a String from the context</li>
 </ul>

 Requests that pass the validation will contain a new key in the routing context with
 the tenant id, for the case of being a default handler the value if this key will be "default".

 @class
*/
var MultiTenantHandler = function(j_val) {

  var j_multiTenantHandler = j_val;
  var that = this;

  var __super_handle = this.handle;
  var __super_create = this.create;
  var __super_create = this.create;
  var __super_create = this.create;
  var __super_addTenantHandler = this.addTenantHandler;
  var __super_removeTenant = this.removeTenant;
  var __super_addDefaultHandler = this.addDefaultHandler;
  /**
   Something has happened, so handle it.

   @public
   @param event {RoutingContext} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_multiTenantHandler["handle(io.vertx.ext.web.RoutingContext)"](__args[0]._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a handler for a given tenant to this handler.

   Both tenant and handler cannot be null.

   @public
   @param tenant {string} the tenant id 
   @param handler {function} the handler to register. 
   @return {MultiTenantHandler} a fluent reference to self.
   */
  this.addTenantHandler =  function(tenant, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_multiTenantHandler["addTenantHandler(java.lang.String,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addTenantHandler != 'undefined') {
      return __super_addTenantHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Remove a handler for a given tenant from this handler.

   Tenant cannot be null.

   @public
   @param tenant {string} the tenant id 
   @return {MultiTenantHandler} a fluent reference to self.
   */
  this.removeTenant =  function(tenant) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_multiTenantHandler["removeTenant(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_removeTenant != 'undefined') {
      return __super_removeTenant.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a default handler for the case when no tenant was matched.

   The handler cannot be null.

   @public
   @param handler {function} the handler to register. 
   @return {MultiTenantHandler} a fluent reference to self.
   */
  this.addDefaultHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_multiTenantHandler["addDefaultHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addDefaultHandler != 'undefined') {
      return __super_addDefaultHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_multiTenantHandler;
};

MultiTenantHandler._jclass = utils.getJavaClass("io.vertx.ext.web.handler.MultiTenantHandler");
MultiTenantHandler._jtype = {accept: function(obj) {
    return MultiTenantHandler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MultiTenantHandler.prototype, {});
    MultiTenantHandler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MultiTenantHandler._create = function(jdel) {var obj = Object.create(MultiTenantHandler.prototype, {});
  MultiTenantHandler.apply(obj, arguments);
  return obj;
}
/**
 Create a MultiTenant handler using a custom tenant extraction function.

 @memberof module:vertx-web-js/multi_tenant_handler
 @param tenantExtractor {function} the function that extracts the tenant id from the request 
 @param contextKey {string} the custom key to store the tenant id in the context 
 @return {MultiTenantHandler} the new handler.
 */
MultiTenantHandler.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(MultiTenantHandler, JMultiTenantHandler["create(java.lang.String)"](__args[0])) ;
  } else if (__args.length === 1 && typeof __args[0] === 'function') {
    return utils.convReturnVertxGen(MultiTenantHandler, JMultiTenantHandler["create(java.util.function.Function)"](function(jVal) {
      var jRet = __args[0](utils.convReturnVertxGen(RoutingContext, jVal));
      return jRet;
    })) ;
  } else if (__args.length === 2 && typeof __args[0] === 'function' && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(MultiTenantHandler, JMultiTenantHandler["create(java.util.function.Function,java.lang.String)"](function(jVal) {
      var jRet = __args[0](utils.convReturnVertxGen(RoutingContext, jVal));
      return jRet;
    }, __args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

MultiTenantHandler.TENANT = JMultiTenantHandler.TENANT;
module.exports = MultiTenantHandler;