/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/tuple */
var utils = require('vertx-js/util/utils');
var Buffer = require('vertx-js/buffer');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JTuple = Java.type('io.vertx.sqlclient.Tuple');

/**
 A general purpose tuple.

 @class
*/
var Tuple = function(j_val) {

  var j_tuple = j_val;
  var that = this;

  var __super_tuple = this.tuple;
  var __super_wrap = this.wrap;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_of = this.of;
  var __super_tuple = this.tuple;
  var __super_getValue = this.getValue;
  var __super_getBoolean = this.getBoolean;
  var __super_getShort = this.getShort;
  var __super_getInteger = this.getInteger;
  var __super_getLong = this.getLong;
  var __super_getFloat = this.getFloat;
  var __super_getDouble = this.getDouble;
  var __super_getString = this.getString;
  var __super_getBuffer = this.getBuffer;
  var __super_addValue = this.addValue;
  var __super_addBoolean = this.addBoolean;
  var __super_addShort = this.addShort;
  var __super_addInteger = this.addInteger;
  var __super_addLong = this.addLong;
  var __super_addFloat = this.addFloat;
  var __super_addDouble = this.addDouble;
  var __super_addString = this.addString;
  var __super_addBuffer = this.addBuffer;
  var __super_get = this.get;
  var __super_size = this.size;
  var __super_clear = this.clear;
  /**
   Get an object value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Object} the value or <code>null</code>
   */
  this.getValue =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnTypeUnknown(j_tuple["getValue(int)"](__args[0])) ;
    } else if (typeof __super_getValue != 'undefined') {
      return __super_getValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a boolean value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {boolean} the value or <code>null</code>
   */
  this.getBoolean =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getBoolean(int)"](__args[0]) ;
    } else if (typeof __super_getBoolean != 'undefined') {
      return __super_getBoolean.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a short value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getShort =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getShort(int)"](__args[0]) ;
    } else if (typeof __super_getShort != 'undefined') {
      return __super_getShort.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get an integer value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getInteger =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getInteger(int)"](__args[0]) ;
    } else if (typeof __super_getInteger != 'undefined') {
      return __super_getInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a long value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getLong =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnLong(j_tuple["getLong(int)"](__args[0])) ;
    } else if (typeof __super_getLong != 'undefined') {
      return __super_getLong.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a float value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getFloat =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getFloat(int)"](__args[0]) ;
    } else if (typeof __super_getFloat != 'undefined') {
      return __super_getFloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a double value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {number} the value or <code>null</code>
   */
  this.getDouble =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getDouble(int)"](__args[0]) ;
    } else if (typeof __super_getDouble != 'undefined') {
      return __super_getDouble.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a string value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {string} the value or <code>null</code>
   */
  this.getString =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_tuple["getString(int)"](__args[0]) ;
    } else if (typeof __super_getString != 'undefined') {
      return __super_getString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get a buffer value at <code>pos</code>.

   @public
   @param pos {number} the position 
   @return {Buffer} the value or <code>null</code>
   */
  this.getBuffer =  function(pos) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(Buffer, j_tuple["getBuffer(int)"](__args[0])) ;
    } else if (typeof __super_getBuffer != 'undefined') {
      return __super_getBuffer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an object value at the end of the tuple.

   @public
   @param value {Object} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addValue =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] !== 'function') {
      j_tuple["addValue(java.lang.Object)"](utils.convParamTypeUnknown(__args[0])) ;
      return that;
    } else if (typeof __super_addValue != 'undefined') {
      return __super_addValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a boolean value at the end of the tuple.

   @public
   @param value {boolean} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addBoolean =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_tuple["addBoolean(java.lang.Boolean)"](__args[0]) ;
      return that;
    } else if (typeof __super_addBoolean != 'undefined') {
      return __super_addBoolean.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a short value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addShort =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addShort(java.lang.Short)"](utils.convParamShort(__args[0])) ;
      return that;
    } else if (typeof __super_addShort != 'undefined') {
      return __super_addShort.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add an integer value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addInteger =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addInteger(java.lang.Integer)"](utils.convParamInteger(__args[0])) ;
      return that;
    } else if (typeof __super_addInteger != 'undefined') {
      return __super_addInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a long value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addLong =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addLong(java.lang.Long)"](utils.convParamLong(__args[0])) ;
      return that;
    } else if (typeof __super_addLong != 'undefined') {
      return __super_addLong.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a float value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addFloat =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addFloat(java.lang.Float)"](utils.convParamFloat(__args[0])) ;
      return that;
    } else if (typeof __super_addFloat != 'undefined') {
      return __super_addFloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a double value at the end of the tuple.

   @public
   @param value {number} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addDouble =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_tuple["addDouble(java.lang.Double)"](utils.convParamDouble(__args[0])) ;
      return that;
    } else if (typeof __super_addDouble != 'undefined') {
      return __super_addDouble.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a string value at the end of the tuple.

   @public
   @param value {string} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addString =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_tuple["addString(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_addString != 'undefined') {
      return __super_addString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a buffer value at the end of the tuple.

   @public
   @param value {Buffer} the value 
   @return {Tuple} a reference to this, so the API can be used fluently
   */
  this.addBuffer =  function(value) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_tuple["addBuffer(io.vertx.core.buffer.Buffer)"](__args[0]._jdel) ;
      return that;
    } else if (typeof __super_addBuffer != 'undefined') {
      return __super_addBuffer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param type {todo} 
   @param pos {number} 
   @return {Object}
   */
  this.get =  function(type, pos) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'function' && typeof __args[1] ==='number') {
      return utils.get_jtype(__args[0]).wrap(j_tuple["get(java.lang.Class,int)"](utils.get_jclass(__args[0]), __args[1])) ;
    } else if (typeof __super_get != 'undefined') {
      return __super_get.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the tuple size
   */
  this.size =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_tuple["size()"]() ;
    } else if (typeof __super_size != 'undefined') {
      return __super_size.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   */
  this.clear =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_tuple["clear()"]();
    } else if (typeof __super_clear != 'undefined') {
      return __super_clear.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_tuple;
};

Tuple._jclass = utils.getJavaClass("io.vertx.sqlclient.Tuple");
Tuple._jtype = {accept: function(obj) {
    return Tuple._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Tuple.prototype, {});
    Tuple.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Tuple._create = function(jdel) {var obj = Object.create(Tuple.prototype, {});
  Tuple.apply(obj, arguments);
  return obj;
}
/**
 Create a tuple with the provided <code>elements</code> list.
 <p/>
 The <code>elements</code> list is not modified.

 @memberof module:vertx-sql-client-js/tuple
 @param elements {Array.<Object>} the list of elements 
 @return {Tuple} the tuple
 */
Tuple.tuple =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(Tuple, JTuple["tuple()"]()) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
    return utils.convReturnVertxGen(Tuple, JTuple["tuple(java.util.List)"](utils.convParamListObject(__args[0]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Wrap the provided <code>list</code> with a tuple.
 <br/>
 The list is not copied and is used as store for tuple elements.

 @memberof module:vertx-sql-client-js/tuple
 @param list {Array.<Object>} 
 @return {Tuple} the list wrapped as a tuple
 */
Tuple.wrap =  function(list) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
    return utils.convReturnVertxGen(Tuple, JTuple["wrap(java.util.List)"](utils.convParamListObject(__args[0]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Create a tuple of six elements.

 @memberof module:vertx-sql-client-js/tuple
 @param elt1 {Object} the first value 
 @param elt2 {Object} the second valueg 
 @param elt3 {Object} the third value 
 @param elt4 {Object} the fourth value 
 @param elt5 {Object} the fifth value 
 @param elt6 {Object} the sixth value 
 @return {Tuple} the tuple
 */
Tuple.of =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object)"](utils.convParamTypeUnknown(__args[0]))) ;
  } else if (__args.length === 2 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]))) ;
  } else if (__args.length === 3 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function' && typeof __args[2] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]), utils.convParamTypeUnknown(__args[2]))) ;
  } else if (__args.length === 4 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function' && typeof __args[2] !== 'function' && typeof __args[3] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]), utils.convParamTypeUnknown(__args[2]), utils.convParamTypeUnknown(__args[3]))) ;
  } else if (__args.length === 5 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function' && typeof __args[2] !== 'function' && typeof __args[3] !== 'function' && typeof __args[4] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]), utils.convParamTypeUnknown(__args[2]), utils.convParamTypeUnknown(__args[3]), utils.convParamTypeUnknown(__args[4]))) ;
  } else if (__args.length === 6 && typeof __args[0] !== 'function' && typeof __args[1] !== 'function' && typeof __args[2] !== 'function' && typeof __args[3] !== 'function' && typeof __args[4] !== 'function' && typeof __args[5] !== 'function') {
    return utils.convReturnVertxGen(Tuple, JTuple["of(java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object,java.lang.Object)"](utils.convParamTypeUnknown(__args[0]), utils.convParamTypeUnknown(__args[1]), utils.convParamTypeUnknown(__args[2]), utils.convParamTypeUnknown(__args[3]), utils.convParamTypeUnknown(__args[4]), utils.convParamTypeUnknown(__args[5]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

Tuple.JSON_NULL = utils.convReturnTypeUnknown(JTuple.JSON_NULL);
module.exports = Tuple;