/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-pg-client-js/pg_subscriber */
var utils = require('vertx-js/util/utils');
var PgConnection = require('vertx-pg-client-js/pg_connection');
var Vertx = require('vertx-js/vertx');
var PgChannel = require('vertx-pg-client-js/pg_channel');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPgSubscriber = Java.type('io.vertx.pgclient.pubsub.PgSubscriber');
var PgConnectOptions = Java.type('io.vertx.pgclient.PgConnectOptions');

/**

 @class
*/
var PgSubscriber = function(j_val) {

  var j_pgSubscriber = j_val;
  var that = this;

  var __super_subscriber = this.subscriber;
  var __super_channel = this.channel;
  var __super_connect = this.connect;
  var __super_reconnectPolicy = this.reconnectPolicy;
  var __super_closeHandler = this.closeHandler;
  var __super_actualConnection = this.actualConnection;
  var __super_closed = this.closed;
  var __super_close = this.close;
  /**
   Return a channel for the given <code>name</code>.

   @public
   @param name {string} the channel name <p/> This will be the name of the channel exactly as held by Postgres for sending notifications. Internally this name will be truncated to the Postgres identifier maxiumum length of <code>(NAMEDATALEN = 64) - 1 == 63</code> characters, and prepared as a quoted identifier without unicode escape sequence support for use in <code>LISTEN/UNLISTEN</code> commands. Examples of channel names and corresponding <code>NOTIFY</code> commands: <ul> <li>when <code>name == "the_channel"</code>: <code>NOTIFY the_channel, 'msg'</code>, <code>NOTIFY The_Channel, 'msg'</code>, or <code>NOTIFY "the_channel", 'msg'</code> succeed in delivering a message to the created channel </li> <li>when <code>name == "The_Channel"</code>: <code>NOTIFY "The_Channel", 'msg'</code>, succeeds in delivering a message to the created channel </li> <li></li> </ul> 
   @return {PgChannel} the channel
   */
  this.channel =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(PgChannel, j_pgSubscriber["channel(java.lang.String)"](__args[0])) ;
    } else if (typeof __super_channel != 'undefined') {
      return __super_channel.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Connect the subscriber to Postgres.

   @public
   @param handler {function} the handler notified of the connection success or failure 
   @return {PgSubscriber} a reference to this, so the API can be used fluently
   */
  this.connect =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgSubscriber["connect(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_connect != 'undefined') {
      return __super_connect.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the reconnect policy that is executed when the subscriber is disconnected.
   <p/>
   When the subscriber is disconnected, the <code>policy</code> function is called with the actual
   number of retries and returns an <code>amountOfTime</code> value:
   <ul>
     <li>when <code>amountOfTime < 0</code>: the subscriber is closed and there is no retry</li>
     <li>when <code>amountOfTime == 0</code>: the subscriber retries to connect immediately</li>
     <li>when <code>amountOfTime > 0</code>: the subscriber retries after <code>amountOfTime</code> milliseconds</li>
   </ul>
   <p/>
   The default policy does not perform any retries.

   @public
   @param policy {function} the policy to set 
   @return {PgSubscriber} a reference to this, so the API can be used fluently
   */
  this.reconnectPolicy =  function(policy) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgSubscriber["reconnectPolicy(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](jVal);
        return utils.convParamLong(jRet);
      }) ;
      return that;
    } else if (typeof __super_reconnectPolicy != 'undefined') {
      return __super_reconnectPolicy.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an handler called when the subscriber is closed.

   @public
   @param handler {function} the handler 
   @return {PgSubscriber} a reference to this, so the API can be used fluently
   */
  this.closeHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pgSubscriber["closeHandler(io.vertx.core.Handler)"](__args[0]) ;
      return that;
    } else if (typeof __super_closeHandler != 'undefined') {
      return __super_closeHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {PgConnection} the actual connection to Postgres, it might be <code>null</code>
   */
  this.actualConnection =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(PgConnection, j_pgSubscriber["actualConnection()"]()) ;
    } else if (typeof __super_actualConnection != 'undefined') {
      return __super_actualConnection.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} whether the subscriber is closed
   */
  this.closed =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_pgSubscriber["closed()"]() ;
    } else if (typeof __super_closed != 'undefined') {
      return __super_closed.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the subscriber, the retry policy will not be invoked.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_pgSubscriber["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pgSubscriber;
};

PgSubscriber._jclass = utils.getJavaClass("io.vertx.pgclient.pubsub.PgSubscriber");
PgSubscriber._jtype = {accept: function(obj) {
    return PgSubscriber._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PgSubscriber.prototype, {});
    PgSubscriber.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PgSubscriber._create = function(jdel) {var obj = Object.create(PgSubscriber.prototype, {});
  PgSubscriber.apply(obj, arguments);
  return obj;
}
/**
 Create a subscriber.

 @memberof module:vertx-pg-client-js/pg_subscriber
 @param vertx {Vertx} the vertx instance 
 @param options {Object} the connect options 
 @return {PgSubscriber} the subscriber
 */
PgSubscriber.subscriber =  function(vertx, options) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(PgSubscriber, JPgSubscriber["subscriber(io.vertx.core.Vertx,io.vertx.pgclient.PgConnectOptions)"](__args[0]._jdel, __args[1]  != null ? new PgConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = PgSubscriber;