/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/sql_result */
var utils = require('vertx-js/util/utils');
var PropertyKind = require('vertx-sql-client-js/property_kind');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JSqlResult = Java.type('io.vertx.sqlclient.SqlResult');

/**
 Represents the result of an operation on database.
 @class
*/
var SqlResult = function(j_val, j_arg_0) {

  var j_sqlResult = j_val;
  var that = this;
  var j_T = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;
  var __super_rowCount = this.rowCount;
  var __super_columnsNames = this.columnsNames;
  var __super_size = this.size;
  var __super_property = this.property;
  var __super_value = this.value;
  var __super_next = this.next;
  /**
   Get the number of the affected rows in the operation to this SqlResult.

   @public

   @return {number} the count of affected rows.
   */
  this.rowCount =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_sqlResult["rowCount()"]() ;
    } else if (typeof __super_rowCount != 'undefined') {
      return __super_rowCount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the names of columns in the SqlResult.

   @public

   @return {Array.<string>} the list of names of columns.
   */
  this.columnsNames =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_sqlResult["columnsNames()"]() ;
    } else if (typeof __super_columnsNames != 'undefined') {
      return __super_columnsNames.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the number of rows retrieved in the SqlResult.

   @public

   @return {number} the count of rows.
   */
  this.size =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_sqlResult["size()"]() ;
    } else if (typeof __super_size != 'undefined') {
      return __super_size.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the property with the specified {@link PropertyKind}.

   @public
   @param propertyKind {PropertyKind} the kind of the property 
   @return {Object} the value of the property
   */
  this.property =  function(propertyKind) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnTypeUnknown(j_sqlResult["property(io.vertx.sqlclient.PropertyKind)"](__args[0]._jdel)) ;
    } else if (typeof __super_property != 'undefined') {
      return __super_property.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the result value.

   @public

   @return {Object} the result
   */
  this.value =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_T.wrap(j_sqlResult["value()"]()) ;
    } else if (typeof __super_value != 'undefined') {
      return __super_value.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Return the next available result or <code>null</code>, e.g for a simple query that executed multiple queries or for
   a batch result.

   @public

   @return {SqlResult} the next available result or <code>null</code> if none is available
   */
  this.next =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(SqlResult, j_sqlResult["next()"](), undefined) ;
    } else if (typeof __super_next != 'undefined') {
      return __super_next.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_sqlResult;
};

SqlResult._jclass = utils.getJavaClass("io.vertx.sqlclient.SqlResult");
SqlResult._jtype = {accept: function(obj) {
    return SqlResult._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(SqlResult.prototype, {});
    SqlResult.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
SqlResult._create = function(jdel) {var obj = Object.create(SqlResult.prototype, {});
  SqlResult.apply(obj, arguments);
  return obj;
}
module.exports = SqlResult;