/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-js/session_handler */
var utils = require('vertx-js/util/utils');
var SessionStore = require('vertx-web-js/session_store');
var RoutingContext = require('vertx-web-js/routing_context');
var AuthProvider = require('vertx-auth-common-js/auth_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JSessionHandler = Java.type('io.vertx.ext.web.handler.SessionHandler');

/**

 @class
*/
var SessionHandler = function(j_val) {

  var j_sessionHandler = j_val;
  var that = this;

  var __super_handle = this.handle;
  var __super_create = this.create;
  var __super_setSessionTimeout = this.setSessionTimeout;
  var __super_setNagHttps = this.setNagHttps;
  var __super_setCookieSecureFlag = this.setCookieSecureFlag;
  var __super_setCookieHttpOnlyFlag = this.setCookieHttpOnlyFlag;
  var __super_setSessionCookieName = this.setSessionCookieName;
  var __super_setSessionCookiePath = this.setSessionCookiePath;
  var __super_setMinLength = this.setMinLength;
  var __super_setCookieSameSite = this.setCookieSameSite;
  var __super_setAuthProvider = this.setAuthProvider;
  /**
   Something has happened, so handle it.

   @public
   @param event {RoutingContext} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_sessionHandler["handle(io.vertx.ext.web.RoutingContext)"](__args[0]._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the session timeout

   @public
   @param timeout {number} the timeout, in ms. 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setSessionTimeout =  function(timeout) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_sessionHandler["setSessionTimeout(long)"](__args[0]) ;
      return that;
    } else if (typeof __super_setSessionTimeout != 'undefined') {
      return __super_setSessionTimeout.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set whether a nagging log warning should be written if the session handler is
   accessed over HTTP, not HTTPS

   @public
   @param nag {boolean} true to nag 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setNagHttps =  function(nag) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_sessionHandler["setNagHttps(boolean)"](__args[0]) ;
      return that;
    } else if (typeof __super_setNagHttps != 'undefined') {
      return __super_setNagHttps.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Sets whether the 'secure' flag should be set for the session cookie. When set
   this flag instructs browsers to only send the cookie over HTTPS. Note that
   this will probably stop your sessions working if used without HTTPS (e.g. in
   development).

   @public
   @param secure {boolean} true to set the secure flag on the cookie 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setCookieSecureFlag =  function(secure) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_sessionHandler["setCookieSecureFlag(boolean)"](__args[0]) ;
      return that;
    } else if (typeof __super_setCookieSecureFlag != 'undefined') {
      return __super_setCookieSecureFlag.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Sets whether the 'HttpOnly' flag should be set for the session cookie. When
   set this flag instructs browsers to prevent Javascript access to the the
   cookie. Used as a line of defence against the most common XSS attacks.

   @public
   @param httpOnly {boolean} true to set the HttpOnly flag on the cookie 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setCookieHttpOnlyFlag =  function(httpOnly) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      j_sessionHandler["setCookieHttpOnlyFlag(boolean)"](__args[0]) ;
      return that;
    } else if (typeof __super_setCookieHttpOnlyFlag != 'undefined') {
      return __super_setCookieHttpOnlyFlag.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the session cookie name

   @public
   @param sessionCookieName {string} the session cookie name 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setSessionCookieName =  function(sessionCookieName) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_sessionHandler["setSessionCookieName(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_setSessionCookieName != 'undefined') {
      return __super_setSessionCookieName.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the session cookie path

   @public
   @param sessionCookiePath {string} the session cookie path 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setSessionCookiePath =  function(sessionCookiePath) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_sessionHandler["setSessionCookiePath(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_setSessionCookiePath != 'undefined') {
      return __super_setSessionCookiePath.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set expected session id minimum length.

   @public
   @param minLength {number} the session id minimal length 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setMinLength =  function(minLength) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_sessionHandler["setMinLength(int)"](__args[0]) ;
      return that;
    } else if (typeof __super_setMinLength != 'undefined') {
      return __super_setMinLength.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the session cookie SameSite policy to use.

   @public
   @param policy {Object} to use, <code>null</code> for no policy. 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setCookieSameSite =  function(policy) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(SessionHandler, j_sessionHandler["setCookieSameSite(io.vertx.core.http.CookieSameSite)"](io.vertx.core.http.CookieSameSite.valueOf(__args[0]))) ;
    } else if (typeof __super_setCookieSameSite != 'undefined') {
      return __super_setCookieSameSite.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an auth provider that will allow retrieving the User object from the session to the current routing context.

   @public
   @param authProvider {AuthProvider} any auth provider. 
   @return {SessionHandler} a reference to this, so the API can be used fluently
   */
  this.setAuthProvider =  function(authProvider) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_sessionHandler["setAuthProvider(io.vertx.ext.auth.AuthProvider)"](__args[0]._jdel) ;
      return that;
    } else if (typeof __super_setAuthProvider != 'undefined') {
      return __super_setAuthProvider.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_sessionHandler;
};

SessionHandler._jclass = utils.getJavaClass("io.vertx.ext.web.handler.SessionHandler");
SessionHandler._jtype = {accept: function(obj) {
    return SessionHandler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(SessionHandler.prototype, {});
    SessionHandler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
SessionHandler._create = function(jdel) {var obj = Object.create(SessionHandler.prototype, {});
  SessionHandler.apply(obj, arguments);
  return obj;
}
/**
 Create a session handler

 @memberof module:vertx-web-js/session_handler
 @param sessionStore {SessionStore} the session store 
 @return {SessionHandler} the handler
 */
SessionHandler.create =  function(sessionStore) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(SessionHandler, JSessionHandler["create(io.vertx.ext.web.sstore.SessionStore)"](__args[0]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

SessionHandler.DEFAULT_SESSION_COOKIE_NAME = JSessionHandler.DEFAULT_SESSION_COOKIE_NAME;
SessionHandler.DEFAULT_SESSION_COOKIE_PATH = JSessionHandler.DEFAULT_SESSION_COOKIE_PATH;
SessionHandler.DEFAULT_SESSION_TIMEOUT = JSessionHandler.DEFAULT_SESSION_TIMEOUT;
SessionHandler.DEFAULT_NAG_HTTPS = JSessionHandler.DEFAULT_NAG_HTTPS;
SessionHandler.DEFAULT_COOKIE_HTTP_ONLY_FLAG = JSessionHandler.DEFAULT_COOKIE_HTTP_ONLY_FLAG;
SessionHandler.DEFAULT_COOKIE_SECURE_FLAG = JSessionHandler.DEFAULT_COOKIE_SECURE_FLAG;
SessionHandler.DEFAULT_SESSIONID_MIN_LENGTH = JSessionHandler.DEFAULT_SESSIONID_MIN_LENGTH;
module.exports = SessionHandler;