/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/property_kind */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPropertyKind = Java.type('io.vertx.sqlclient.PropertyKind');

/**
 Represents which kind the property is.

 @class
*/
var PropertyKind = function(j_val, j_arg_0) {

  var j_propertyKind = j_val;
  var that = this;
  var j_T = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;
  var __super_create = this.create;
  var __super_name = this.name;
  /**

   @public

   @return {string} the property name
   */
  this.name =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_propertyKind["name()"]() ;
    } else if (typeof __super_name != 'undefined') {
      return __super_name.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_propertyKind;
};

PropertyKind._jclass = utils.getJavaClass("io.vertx.sqlclient.PropertyKind");
PropertyKind._jtype = {accept: function(obj) {
    return PropertyKind._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PropertyKind.prototype, {});
    PropertyKind.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PropertyKind._create = function(jdel) {var obj = Object.create(PropertyKind.prototype, {});
  PropertyKind.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-sql-client-js/property_kind
 @param name {string} 
 @param type {todo} 
 @return {PropertyKind} a property kind matching the provided <code>name</code>, the <code>type</code> can be used to check the property value type or cast it to the expected type
 */
PropertyKind.create =  function(name, type) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
    return utils.convReturnVertxGen(PropertyKind, JPropertyKind["create(java.lang.String,java.lang.Class)"](__args[0], utils.get_jclass(__args[1])), utils.get_jtype(__args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = PropertyKind;