/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/prepared_statement */
var utils = require('vertx-js/util/utils');
var RowStream = require('vertx-sql-client-js/row_stream');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var Cursor = require('vertx-sql-client-js/cursor');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');
var Tuple = require('vertx-sql-client-js/tuple');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPreparedStatement = Java.type('io.vertx.sqlclient.PreparedStatement');

/**
 A prepared statement, the statement is pre-compiled and it's more efficient to execute the statement for multiple times.
 In addition, this kind of statement provides protection against SQL injection attacks.

 <p>From a prepared statement you can

 <ul>
 @class
*/
var PreparedStatement = function(j_val) {

  var j_preparedStatement = j_val;
  var that = this;

  var __super_query = this.query;
  var __super_cursor = this.cursor;
  var __super_cursor = this.cursor;
  var __super_createStream = this.createStream;
  var __super_createStream = this.createStream;
  var __super_close = this.close;
  var __super_close = this.close;
  /**
   Create a prepared query for this statement.

   @public

   @return {PreparedQuery} the prepared query
   */
  this.query =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(PreparedQuery, j_preparedStatement["query()"](), RowSet._jtype) ;
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create a cursor with the provided <code>arguments</code>.

   @public
   @param args {Tuple} the list of arguments 
   @return {Cursor} the query
   */
  this.cursor =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Cursor, j_preparedStatement["cursor()"]()) ;
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(Cursor, j_preparedStatement["cursor(io.vertx.sqlclient.Tuple)"](__args[0]._jdel)) ;
    } else if (typeof __super_cursor != 'undefined') {
      return __super_cursor.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
   with a <code>fetch</code> size to fetch the results.
   <p/>
   Note: this requires to be in a transaction, since cursors require it.

   @public
   @param fetch {number} the cursor fetch size 
   @param args {Tuple} the prepared query arguments 
   @return {RowStream} the createStream
   */
  this.createStream =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return utils.convReturnVertxGen(RowStream, j_preparedStatement["createStream(int)"](__args[0]), Row._jtype) ;
    } else if (__args.length === 2 && typeof __args[0] ==='number' && typeof __args[1] === 'object' && __args[1]._jdel) {
      return utils.convReturnVertxGen(RowStream, j_preparedStatement["createStream(int,io.vertx.sqlclient.Tuple)"](__args[0], __args[1]._jdel), Row._jtype) ;
    } else if (typeof __super_createStream != 'undefined') {
      return __super_createStream.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Like {@link PreparedStatement#close} but notifies the <code>completionHandler</code> when it's closed.

   @public
   @param completionHandler {function} 
   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_preparedStatement["close()"]();
    } else if (__args.length === 1 && typeof __args[0] === 'function') {
      j_preparedStatement["close(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_preparedStatement;
};

PreparedStatement._jclass = utils.getJavaClass("io.vertx.sqlclient.PreparedStatement");
PreparedStatement._jtype = {accept: function(obj) {
    return PreparedStatement._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PreparedStatement.prototype, {});
    PreparedStatement.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PreparedStatement._create = function(jdel) {var obj = Object.create(PreparedStatement.prototype, {});
  PreparedStatement.apply(obj, arguments);
  return obj;
}
module.exports = PreparedStatement;