/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-templ-freemarker-js/free_marker_template_engine */
var utils = require('vertx-js/util/utils');
var TemplateEngine = require('vertx-web-common-js/template_engine');
var Vertx = require('vertx-js/vertx');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JFreeMarkerTemplateEngine = Java.type('io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine');

/**
 A template engine that uses the FreeMarker library.

 @class
*/
var FreeMarkerTemplateEngine = function(j_val) {

  var j_freeMarkerTemplateEngine = j_val;
  var that = this;
  TemplateEngine.call(this, j_val);

  var __super_create = this.create;
  var __super_setExtension = this.setExtension;
  var __super_setMaxCacheSize = this.setMaxCacheSize;
  /**

   @public
   @param extension {string} the extension 
   @return {FreeMarkerTemplateEngine} a reference to this for fluency
   */
  this.setExtension =  function(extension) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_freeMarkerTemplateEngine["setExtension(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_setExtension != 'undefined') {
      return __super_setExtension.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set the max cache size for the engine

   @public
   @param maxCacheSize {number} the maxCacheSize 
   @return {FreeMarkerTemplateEngine} a reference to this for fluency
   */
  this.setMaxCacheSize =  function(maxCacheSize) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      j_freeMarkerTemplateEngine["setMaxCacheSize(int)"](__args[0]) ;
      return that;
    } else if (typeof __super_setMaxCacheSize != 'undefined') {
      return __super_setMaxCacheSize.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_freeMarkerTemplateEngine;
};

FreeMarkerTemplateEngine._jclass = utils.getJavaClass("io.vertx.ext.web.templ.freemarker.FreeMarkerTemplateEngine");
FreeMarkerTemplateEngine._jtype = {accept: function(obj) {
    return FreeMarkerTemplateEngine._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(FreeMarkerTemplateEngine.prototype, {});
    FreeMarkerTemplateEngine.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
FreeMarkerTemplateEngine._create = function(jdel) {var obj = Object.create(FreeMarkerTemplateEngine.prototype, {});
  FreeMarkerTemplateEngine.apply(obj, arguments);
  return obj;
}
/**
 Create a template engine using defaults

 @memberof module:vertx-web-templ-freemarker-js/free_marker_template_engine
 @param vertx {Vertx} 
 @return {FreeMarkerTemplateEngine} the engine
 */
FreeMarkerTemplateEngine.create =  function(vertx) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(FreeMarkerTemplateEngine, JFreeMarkerTemplateEngine["create(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

FreeMarkerTemplateEngine.DEFAULT_MAX_CACHE_SIZE = JFreeMarkerTemplateEngine.DEFAULT_MAX_CACHE_SIZE;
FreeMarkerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION = JFreeMarkerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
module.exports = FreeMarkerTemplateEngine;