/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-client-js/web_client_session */
var utils = require('vertx-js/util/utils');
var Buffer = require('vertx-js/buffer');
var WebClient = require('vertx-web-client-js/web_client');
var HttpRequest = require('vertx-web-client-js/http_request');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JWebClientSession = Java.type('io.vertx.ext.web.client.WebClientSession');

/**

 @class
*/
var WebClientSession = function(j_val) {

  var j_webClientSession = j_val;
  var that = this;
  WebClient.call(this, j_val);

  var __super_create = this.create;
  var __super_addHeader = this.addHeader;
  var __super_removeHeader = this.removeHeader;
  /**
   Configure the client to add an HTTP header to every request.

   @public
   @param name {string} the header name 
   @param value {string} the header value 
   @return {WebClientSession} a reference to this, so the API can be used fluently
   */
  this.addHeader =  function(name, value) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      j_webClientSession["addHeader(java.lang.String,java.lang.String)"](__args[0], __args[1]) ;
      return that;
    } else if (typeof __super_addHeader != 'undefined') {
      return __super_addHeader.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Removes a previously added header.

   @public
   @param name {string} the header name 
   @return {WebClientSession} a reference to this, so the API can be used fluently
   */
  this.removeHeader =  function(name) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_webClientSession["removeHeader(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_removeHeader != 'undefined') {
      return __super_removeHeader.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_webClientSession;
};

WebClientSession._jclass = utils.getJavaClass("io.vertx.ext.web.client.WebClientSession");
WebClientSession._jtype = {accept: function(obj) {
    return WebClientSession._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(WebClientSession.prototype, {});
    WebClientSession.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
WebClientSession._create = function(jdel) {var obj = Object.create(WebClientSession.prototype, {});
  WebClientSession.apply(obj, arguments);
  return obj;
}
/**
 Create a session aware web client using the provided <code>webClient</code> instance.

 @memberof module:vertx-web-client-js/web_client_session
 @param webClient {WebClient} the web client instance 
 @return {WebClientSession} the created client
 */
WebClientSession.create =  function(webClient) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(WebClientSession, JWebClientSession["create(io.vertx.ext.web.client.WebClient)"](__args[0]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = WebClientSession;