/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/pool */
var utils = require('vertx-js/util/utils');
var SqlClient = require('vertx-sql-client-js/sql_client');
var SqlConnection = require('vertx-sql-client-js/sql_connection');
var Query = require('vertx-sql-client-js/query');
var Vertx = require('vertx-js/vertx');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var Transaction = require('vertx-sql-client-js/transaction');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPool = Java.type('io.vertx.sqlclient.Pool');
var SqlConnectOptions = Java.type('io.vertx.sqlclient.SqlConnectOptions');
var PoolOptions = Java.type('io.vertx.sqlclient.PoolOptions');

/**
 A pool of SQL connections.

 @class
*/
var Pool = function(j_val) {

  var j_pool = j_val;
  var that = this;
  SqlClient.call(this, j_val);

  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_pool = this.pool;
  var __super_getConnection = this.getConnection;
  var __super_query = this.query;
  var __super_preparedQuery = this.preparedQuery;
  var __super_begin = this.begin;
  var __super_close = this.close;
  /**
   Get a connection from the pool.

   @public
   @param handler {function} the handler that will get the connection result 
   */
  this.getConnection =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pool["getConnection(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(SqlConnection, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_getConnection != 'undefined') {
      return __super_getConnection.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   

   A connection is borrowed from the connection pool when the query is executed and then immediately returned
   to the pool after it completes.

   @public
   @param sql {string} 
   @return {Query}
   */
  this.query =  function(sql) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(Query, j_pool["query(java.lang.String)"](__args[0]), RowSet._jtype) ;
    } else if (typeof __super_query != 'undefined') {
      return __super_query.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   

   A connection is borrowed from the connection pool when the query is executed and then immediately returned
   to the pool after it completes.

   @public
   @param sql {string} 
   @return {PreparedQuery}
   */
  this.preparedQuery =  function(sql) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return utils.convReturnVertxGen(PreparedQuery, j_pool["preparedQuery(java.lang.String)"](__args[0]), RowSet._jtype) ;
    } else if (typeof __super_preparedQuery != 'undefined') {
      return __super_preparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
   to the pool when the transaction ends.

   @public
   @param handler {function} 
   */
  this.begin =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_pool["begin(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Transaction, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_begin != 'undefined') {
      return __super_begin.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the pool and release the associated resources.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_pool["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pool;
};

Pool._jclass = utils.getJavaClass("io.vertx.sqlclient.Pool");
Pool._jtype = {accept: function(obj) {
    return Pool._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Pool.prototype, {});
    Pool.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Pool._create = function(jdel) {var obj = Object.create(Pool.prototype, {});
  Pool.apply(obj, arguments);
  return obj;
}
/**
 Create a connection pool to the database configured with the given <code>connectOptions</code> and <code>poolOptions</code>.

 @memberof module:vertx-sql-client-js/pool
 @param vertx {Vertx} the Vertx instance to be used with the connection pool 
 @param connectOptions {Object} the options used to create the connection pool, such as database hostname 
 @param poolOptions {Object} the options for creating the pool 
 @return {Pool} the connection pool
 */
Pool.pool =  function() {
  var __args = arguments;
  if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
    return utils.convReturnVertxGen(Pool, JPool["pool(io.vertx.sqlclient.SqlConnectOptions)"](__args[0]  != null ? new SqlConnectOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null)) ;
  } else if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(Pool, JPool["pool(io.vertx.sqlclient.SqlConnectOptions,io.vertx.sqlclient.PoolOptions)"](__args[0]  != null ? new SqlConnectOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, __args[1]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null)) {
    return utils.convReturnVertxGen(Pool, JPool["pool(io.vertx.core.Vertx,io.vertx.sqlclient.SqlConnectOptions,io.vertx.sqlclient.PoolOptions)"](__args[0]._jdel, __args[1]  != null ? new SqlConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, __args[2]  != null ? new PoolOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = Pool;