/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-graphql-js/graph_ql_handler */
var utils = require('vertx-js/util/utils');
var RoutingContext = require('vertx-web-js/routing_context');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JGraphQLHandler = Java.type('io.vertx.ext.web.handler.graphql.GraphQLHandler');
var GraphQLHandlerOptions = Java.type('io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions');

/**

 @class
*/
var GraphQLHandler = function(j_val) {

  var j_graphQLHandler = j_val;
  var that = this;

  var __super_handle = this.handle;
  var __super_queryContext = this.queryContext;
  /**
   Something has happened, so handle it.

   @public
   @param event {RoutingContext} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_graphQLHandler["handle(io.vertx.ext.web.RoutingContext)"](__args[0]._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Customize the query context object.
   The provided <code>factory</code> method will be invoked for each incoming GraphQL request.

   @public
   @param factory {function} 
   @return {GraphQLHandler} a reference to this, so the API can be used fluently
   */
  this.queryContext =  function(factory) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_graphQLHandler["queryContext(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnVertxGen(RoutingContext, jVal));
        return utils.convParamTypeUnknown(jRet);
      }) ;
      return that;
    } else if (typeof __super_queryContext != 'undefined') {
      return __super_queryContext.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_graphQLHandler;
};

GraphQLHandler._jclass = utils.getJavaClass("io.vertx.ext.web.handler.graphql.GraphQLHandler");
GraphQLHandler._jtype = {accept: function(obj) {
    return GraphQLHandler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(GraphQLHandler.prototype, {});
    GraphQLHandler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
GraphQLHandler._create = function(jdel) {var obj = Object.create(GraphQLHandler.prototype, {});
  GraphQLHandler.apply(obj, arguments);
  return obj;
}
module.exports = GraphQLHandler;