/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-graphql-js/graphi_ql_handler */
var utils = require('vertx-js/util/utils');
var MultiMap = require('vertx-js/multi_map');
var RoutingContext = require('vertx-web-js/routing_context');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JGraphiQLHandler = Java.type('io.vertx.ext.web.handler.graphql.GraphiQLHandler');
var GraphiQLHandlerOptions = Java.type('io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions');

/**

 @class
*/
var GraphiQLHandler = function(j_val) {

  var j_graphiQLHandler = j_val;
  var that = this;

  var __super_handle = this.handle;
  var __super_create = this.create;
  var __super_create = this.create;
  var __super_graphiQLRequestHeaders = this.graphiQLRequestHeaders;
  /**
   Something has happened, so handle it.

   @public
   @param event {RoutingContext} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_graphiQLHandler["handle(io.vertx.ext.web.RoutingContext)"](__args[0]._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Customize the HTTP headers to add to GraphQL requests sent by the GraphiQL user interface.
   The result will be applied on top of the fixed set of headers specified in <a href="../../dataobjects.html#GraphiQLHandlerOptions">GraphiQLHandlerOptions</a>.
   <p>
   This can be useful if, for example, the server is protected by authentication.

   @public
   @param factory {function} 
   @return {GraphiQLHandler} a reference to this, so the API can be used fluently
   */
  this.graphiQLRequestHeaders =  function(factory) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_graphiQLHandler["graphiQLRequestHeaders(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnVertxGen(RoutingContext, jVal));
        return jRet._jdel;
      }) ;
      return that;
    } else if (typeof __super_graphiQLRequestHeaders != 'undefined') {
      return __super_graphiQLRequestHeaders.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_graphiQLHandler;
};

GraphiQLHandler._jclass = utils.getJavaClass("io.vertx.ext.web.handler.graphql.GraphiQLHandler");
GraphiQLHandler._jtype = {accept: function(obj) {
    return GraphiQLHandler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(GraphiQLHandler.prototype, {});
    GraphiQLHandler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
GraphiQLHandler._create = function(jdel) {var obj = Object.create(GraphiQLHandler.prototype, {});
  GraphiQLHandler.apply(obj, arguments);
  return obj;
}
/**
 Create a new {@link GraphiQLHandler}.
 <p>
 The handler will be configured with the given <code>options</code>.

 @memberof module:vertx-web-graphql-js/graphi_ql_handler
 @param options {Object} options for configuring the {@link GraphiQLHandler} 
 @return {GraphiQLHandler}
 */
GraphiQLHandler.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(GraphiQLHandler, JGraphiQLHandler["create()"]()) ;
  } else if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
    return utils.convReturnVertxGen(GraphiQLHandler, JGraphiQLHandler["create(io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions)"](__args[0]  != null ? new GraphiQLHandlerOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = GraphiQLHandler;