/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/database_metadata */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JDatabaseMetadata = Java.type('io.vertx.sqlclient.spi.DatabaseMetadata');

/**
 Contains static metadata about the backend database server 

 @class
*/
var DatabaseMetadata = function(j_val) {

  var j_databaseMetadata = j_val;
  var that = this;

  var __super_productName = this.productName;
  var __super_fullVersion = this.fullVersion;
  var __super_majorVersion = this.majorVersion;
  var __super_minorVersion = this.minorVersion;
  /**

   @public

   @return {string} The product name of the backend database server
   */
  this.productName =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_databaseMetadata["productName()"]() ;
    } else if (typeof __super_productName != 'undefined') {
      return __super_productName.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} The full version string for the backend database server. This may be useful for for parsing more subtle aspects of the version string. For simple information like database major and minor version, use {@link DatabaseMetadata#majorVersion} and {@link DatabaseMetadata#minorVersion} instead.
   */
  this.fullVersion =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_databaseMetadata["fullVersion()"]() ;
    } else if (typeof __super_fullVersion != 'undefined') {
      return __super_fullVersion.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} The major version of the backend database server
   */
  this.majorVersion =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_databaseMetadata["majorVersion()"]() ;
    } else if (typeof __super_majorVersion != 'undefined') {
      return __super_majorVersion.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} The minor version of the backend database server
   */
  this.minorVersion =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_databaseMetadata["minorVersion()"]() ;
    } else if (typeof __super_minorVersion != 'undefined') {
      return __super_minorVersion.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_databaseMetadata;
};

DatabaseMetadata._jclass = utils.getJavaClass("io.vertx.sqlclient.spi.DatabaseMetadata");
DatabaseMetadata._jtype = {accept: function(obj) {
    return DatabaseMetadata._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(DatabaseMetadata.prototype, {});
    DatabaseMetadata.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
DatabaseMetadata._create = function(jdel) {var obj = Object.create(DatabaseMetadata.prototype, {});
  DatabaseMetadata.apply(obj, arguments);
  return obj;
}
module.exports = DatabaseMetadata;