/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-redis-js/redis_api */
var utils = require('vertx-js/util/utils');
var Response = require('vertx-redis-js/response');
var Redis = require('vertx-redis-js/redis');
var RedisConnection = require('vertx-redis-js/redis_connection');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JRedisAPI = Java.type('io.vertx.redis.client.RedisAPI');

/**
 <b>Auto generated</b> Redis API client wrapper.

 @class
*/
var RedisAPI = function(j_val) {

  var j_redisAPI = j_val;
  var that = this;

  var __super_close = this.close;
  var __super_append = this.append;
  var __super_asking = this.asking;
  var __super_auth = this.auth;
  var __super_bgrewriteaof = this.bgrewriteaof;
  var __super_bgsave = this.bgsave;
  var __super_bitcount = this.bitcount;
  var __super_bitfield = this.bitfield;
  var __super_bitop = this.bitop;
  var __super_bitpos = this.bitpos;
  var __super_blpop = this.blpop;
  var __super_brpop = this.brpop;
  var __super_brpoplpush = this.brpoplpush;
  var __super_bzpopmax = this.bzpopmax;
  var __super_bzpopmin = this.bzpopmin;
  var __super_client = this.client;
  var __super_cluster = this.cluster;
  var __super_command = this.command;
  var __super_config = this.config;
  var __super_dbsize = this.dbsize;
  var __super_debug = this.debug;
  var __super_decr = this.decr;
  var __super_decrby = this.decrby;
  var __super_del = this.del;
  var __super_discard = this.discard;
  var __super_dump = this.dump;
  var __super_echo = this.echo;
  var __super_eval = this.eval;
  var __super_evalsha = this.evalsha;
  var __super_exec = this.exec;
  var __super_exists = this.exists;
  var __super_expire = this.expire;
  var __super_expireat = this.expireat;
  var __super_flushall = this.flushall;
  var __super_flushdb = this.flushdb;
  var __super_geoadd = this.geoadd;
  var __super_geodist = this.geodist;
  var __super_geohash = this.geohash;
  var __super_geopos = this.geopos;
  var __super_georadius = this.georadius;
  var __super_georadiusRo = this.georadiusRo;
  var __super_georadiusbymember = this.georadiusbymember;
  var __super_georadiusbymemberRo = this.georadiusbymemberRo;
  var __super_get = this.get;
  var __super_getbit = this.getbit;
  var __super_getrange = this.getrange;
  var __super_getset = this.getset;
  var __super_hdel = this.hdel;
  var __super_hexists = this.hexists;
  var __super_hget = this.hget;
  var __super_hgetall = this.hgetall;
  var __super_hincrby = this.hincrby;
  var __super_hincrbyfloat = this.hincrbyfloat;
  var __super_hkeys = this.hkeys;
  var __super_hlen = this.hlen;
  var __super_hmget = this.hmget;
  var __super_hmset = this.hmset;
  var __super_host = this.host;
  var __super_hscan = this.hscan;
  var __super_hset = this.hset;
  var __super_hsetnx = this.hsetnx;
  var __super_hstrlen = this.hstrlen;
  var __super_hvals = this.hvals;
  var __super_incr = this.incr;
  var __super_incrby = this.incrby;
  var __super_incrbyfloat = this.incrbyfloat;
  var __super_info = this.info;
  var __super_keys = this.keys;
  var __super_lastsave = this.lastsave;
  var __super_latency = this.latency;
  var __super_lindex = this.lindex;
  var __super_linsert = this.linsert;
  var __super_llen = this.llen;
  var __super_lolwut = this.lolwut;
  var __super_lpop = this.lpop;
  var __super_lpush = this.lpush;
  var __super_lpushx = this.lpushx;
  var __super_lrange = this.lrange;
  var __super_lrem = this.lrem;
  var __super_lset = this.lset;
  var __super_ltrim = this.ltrim;
  var __super_memory = this.memory;
  var __super_mget = this.mget;
  var __super_migrate = this.migrate;
  var __super_module = this.module;
  var __super_monitor = this.monitor;
  var __super_move = this.move;
  var __super_mset = this.mset;
  var __super_msetnx = this.msetnx;
  var __super_multi = this.multi;
  var __super_object = this.object;
  var __super_persist = this.persist;
  var __super_pexpire = this.pexpire;
  var __super_pexpireat = this.pexpireat;
  var __super_pfadd = this.pfadd;
  var __super_pfcount = this.pfcount;
  var __super_pfdebug = this.pfdebug;
  var __super_pfmerge = this.pfmerge;
  var __super_pfselftest = this.pfselftest;
  var __super_ping = this.ping;
  var __super_post = this.post;
  var __super_psetex = this.psetex;
  var __super_psubscribe = this.psubscribe;
  var __super_psync = this.psync;
  var __super_pttl = this.pttl;
  var __super_publish = this.publish;
  var __super_pubsub = this.pubsub;
  var __super_punsubscribe = this.punsubscribe;
  var __super_randomkey = this.randomkey;
  var __super_readonly = this.readonly;
  var __super_readwrite = this.readwrite;
  var __super_rename = this.rename;
  var __super_renamenx = this.renamenx;
  var __super_replconf = this.replconf;
  var __super_replicaof = this.replicaof;
  var __super_restore = this.restore;
  var __super_restoreAsking = this.restoreAsking;
  var __super_role = this.role;
  var __super_rpop = this.rpop;
  var __super_rpoplpush = this.rpoplpush;
  var __super_rpush = this.rpush;
  var __super_rpushx = this.rpushx;
  var __super_sadd = this.sadd;
  var __super_save = this.save;
  var __super_scan = this.scan;
  var __super_scard = this.scard;
  var __super_script = this.script;
  var __super_sdiff = this.sdiff;
  var __super_sdiffstore = this.sdiffstore;
  var __super_select = this.select;
  var __super_set = this.set;
  var __super_setbit = this.setbit;
  var __super_setex = this.setex;
  var __super_setnx = this.setnx;
  var __super_setrange = this.setrange;
  var __super_shutdown = this.shutdown;
  var __super_sinter = this.sinter;
  var __super_sinterstore = this.sinterstore;
  var __super_sismember = this.sismember;
  var __super_slaveof = this.slaveof;
  var __super_slowlog = this.slowlog;
  var __super_smembers = this.smembers;
  var __super_smove = this.smove;
  var __super_sort = this.sort;
  var __super_spop = this.spop;
  var __super_srandmember = this.srandmember;
  var __super_srem = this.srem;
  var __super_sscan = this.sscan;
  var __super_strlen = this.strlen;
  var __super_subscribe = this.subscribe;
  var __super_substr = this.substr;
  var __super_sunion = this.sunion;
  var __super_sunionstore = this.sunionstore;
  var __super_swapdb = this.swapdb;
  var __super_sync = this.sync;
  var __super_time = this.time;
  var __super_touch = this.touch;
  var __super_ttl = this.ttl;
  var __super_type = this.type;
  var __super_unlink = this.unlink;
  var __super_unsubscribe = this.unsubscribe;
  var __super_unwatch = this.unwatch;
  var __super_wait = this.wait;
  var __super_watch = this.watch;
  var __super_xack = this.xack;
  var __super_xadd = this.xadd;
  var __super_xclaim = this.xclaim;
  var __super_xdel = this.xdel;
  var __super_xgroup = this.xgroup;
  var __super_xinfo = this.xinfo;
  var __super_xlen = this.xlen;
  var __super_xpending = this.xpending;
  var __super_xrange = this.xrange;
  var __super_xread = this.xread;
  var __super_xreadgroup = this.xreadgroup;
  var __super_xrevrange = this.xrevrange;
  var __super_xsetid = this.xsetid;
  var __super_xtrim = this.xtrim;
  var __super_zadd = this.zadd;
  var __super_zcard = this.zcard;
  var __super_zcount = this.zcount;
  var __super_zincrby = this.zincrby;
  var __super_zinterstore = this.zinterstore;
  var __super_zlexcount = this.zlexcount;
  var __super_zpopmax = this.zpopmax;
  var __super_zpopmin = this.zpopmin;
  var __super_zrange = this.zrange;
  var __super_zrangebylex = this.zrangebylex;
  var __super_zrangebyscore = this.zrangebyscore;
  var __super_zrank = this.zrank;
  var __super_zrem = this.zrem;
  var __super_zremrangebylex = this.zremrangebylex;
  var __super_zremrangebyrank = this.zremrangebyrank;
  var __super_zremrangebyscore = this.zremrangebyscore;
  var __super_zrevrange = this.zrevrange;
  var __super_zrevrangebylex = this.zrevrangebylex;
  var __super_zrevrangebyscore = this.zrevrangebyscore;
  var __super_zrevrank = this.zrevrank;
  var __super_zscan = this.zscan;
  var __super_zscore = this.zscore;
  var __super_zunionstore = this.zunionstore;
  /**

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_redisAPI["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/append">append</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.append =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["append(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_append != 'undefined') {
      return __super_append.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/asking">asking</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.asking =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["asking(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_asking != 'undefined') {
      return __super_asking.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/auth">auth</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.auth =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["auth(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_auth != 'undefined') {
      return __super_auth.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.bgrewriteaof =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["bgrewriteaof(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bgrewriteaof != 'undefined') {
      return __super_bgrewriteaof.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.bgsave =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["bgsave(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bgsave != 'undefined') {
      return __super_bgsave.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.bitcount =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["bitcount(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bitcount != 'undefined') {
      return __super_bitcount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.bitfield =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["bitfield(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bitfield != 'undefined') {
      return __super_bitfield.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/bitop">bitop</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.bitop =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["bitop(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bitop != 'undefined') {
      return __super_bitop.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.bitpos =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["bitpos(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bitpos != 'undefined') {
      return __super_bitpos.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/blpop">blpop</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.blpop =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["blpop(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_blpop != 'undefined') {
      return __super_blpop.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/brpop">brpop</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.brpop =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["brpop(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_brpop != 'undefined') {
      return __super_brpop.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.brpoplpush =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["brpoplpush(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_brpoplpush != 'undefined') {
      return __super_brpoplpush.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.bzpopmax =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["bzpopmax(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bzpopmax != 'undefined') {
      return __super_bzpopmax.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.bzpopmin =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["bzpopmin(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bzpopmin != 'undefined') {
      return __super_bzpopmin.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/client">client</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.client =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["client(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_client != 'undefined') {
      return __super_client.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/cluster">cluster</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.cluster =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["cluster(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_cluster != 'undefined') {
      return __super_cluster.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/command">command</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.command =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["command(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_command != 'undefined') {
      return __super_command.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/config">config</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.config =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["config(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_config != 'undefined') {
      return __super_config.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.dbsize =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["dbsize(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_dbsize != 'undefined') {
      return __super_dbsize.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/debug">debug</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.debug =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["debug(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_debug != 'undefined') {
      return __super_debug.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/decr">decr</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.decr =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["decr(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_decr != 'undefined') {
      return __super_decr.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/decrby">decrby</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.decrby =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["decrby(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_decrby != 'undefined') {
      return __super_decrby.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/del">del</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.del =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["del(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_del != 'undefined') {
      return __super_del.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/discard">discard</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.discard =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["discard(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_discard != 'undefined') {
      return __super_discard.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/dump">dump</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.dump =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["dump(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_dump != 'undefined') {
      return __super_dump.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/echo">echo</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.echo =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["echo(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_echo != 'undefined') {
      return __super_echo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/eval">eval</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.eval =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["eval(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_eval != 'undefined') {
      return __super_eval.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.evalsha =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["evalsha(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_evalsha != 'undefined') {
      return __super_evalsha.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/exec">exec</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.exec =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["exec(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_exec != 'undefined') {
      return __super_exec.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/exists">exists</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.exists =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["exists(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_exists != 'undefined') {
      return __super_exists.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/expire">expire</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.expire =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["expire(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_expire != 'undefined') {
      return __super_expire.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/expireat">expireat</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.expireat =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["expireat(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_expireat != 'undefined') {
      return __super_expireat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/flushall">flushall</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.flushall =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["flushall(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_flushall != 'undefined') {
      return __super_flushall.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.flushdb =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["flushdb(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_flushdb != 'undefined') {
      return __super_flushdb.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.geoadd =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["geoadd(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_geoadd != 'undefined') {
      return __super_geoadd.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/geodist">geodist</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.geodist =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["geodist(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_geodist != 'undefined') {
      return __super_geodist.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/geohash">geohash</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.geohash =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["geohash(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_geohash != 'undefined') {
      return __super_geohash.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/geopos">geopos</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.geopos =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["geopos(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_geopos != 'undefined') {
      return __super_geopos.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/georadius">georadius</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.georadius =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["georadius(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_georadius != 'undefined') {
      return __super_georadius.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.georadiusRo =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["georadiusRo(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_georadiusRo != 'undefined') {
      return __super_georadiusRo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.georadiusbymember =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["georadiusbymember(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_georadiusbymember != 'undefined') {
      return __super_georadiusbymember.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.georadiusbymemberRo =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["georadiusbymemberRo(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_georadiusbymemberRo != 'undefined') {
      return __super_georadiusbymemberRo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/get">get</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.get =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["get(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_get != 'undefined') {
      return __super_get.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/getbit">getbit</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.getbit =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["getbit(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getbit != 'undefined') {
      return __super_getbit.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/getrange">getrange</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.getrange =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["getrange(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getrange != 'undefined') {
      return __super_getrange.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/getset">getset</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.getset =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["getset(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getset != 'undefined') {
      return __super_getset.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hdel">hdel</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hdel =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["hdel(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hdel != 'undefined') {
      return __super_hdel.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hexists">hexists</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hexists =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["hexists(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hexists != 'undefined') {
      return __super_hexists.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hget">hget</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hget =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["hget(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hget != 'undefined') {
      return __super_hget.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hgetall =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["hgetall(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hgetall != 'undefined') {
      return __super_hgetall.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hincrby =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["hincrby(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hincrby != 'undefined') {
      return __super_hincrby.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hincrbyfloat =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["hincrbyfloat(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hincrbyfloat != 'undefined') {
      return __super_hincrbyfloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hkeys =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["hkeys(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hkeys != 'undefined') {
      return __super_hkeys.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hlen">hlen</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hlen =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["hlen(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hlen != 'undefined') {
      return __super_hlen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hmget">hmget</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hmget =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["hmget(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hmget != 'undefined') {
      return __super_hmget.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hmset">hmset</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hmset =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["hmset(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hmset != 'undefined') {
      return __super_hmset.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/host:">host</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.host =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["host(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_host != 'undefined') {
      return __super_host.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hscan">hscan</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hscan =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["hscan(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hscan != 'undefined') {
      return __super_hscan.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hset">hset</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hset =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["hset(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hset != 'undefined') {
      return __super_hset.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hsetnx =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["hsetnx(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hsetnx != 'undefined') {
      return __super_hsetnx.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hstrlen =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["hstrlen(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hstrlen != 'undefined') {
      return __super_hstrlen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/hvals">hvals</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.hvals =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["hvals(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_hvals != 'undefined') {
      return __super_hvals.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/incr">incr</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.incr =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["incr(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_incr != 'undefined') {
      return __super_incr.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/incrby">incrby</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.incrby =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["incrby(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_incrby != 'undefined') {
      return __super_incrby.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.incrbyfloat =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["incrbyfloat(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_incrbyfloat != 'undefined') {
      return __super_incrbyfloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/info">info</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.info =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["info(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_info != 'undefined') {
      return __super_info.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/keys">keys</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.keys =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["keys(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_keys != 'undefined') {
      return __super_keys.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lastsave =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["lastsave(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lastsave != 'undefined') {
      return __super_lastsave.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/latency">latency</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.latency =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["latency(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_latency != 'undefined') {
      return __super_latency.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lindex">lindex</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lindex =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["lindex(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lindex != 'undefined') {
      return __super_lindex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/linsert">linsert</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param arg3 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.linsert =  function(arg0, arg1, arg2, arg3, handler) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'string' && typeof __args[4] === 'function') {
      j_redisAPI["linsert(java.lang.String,java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], __args[3], function(ar) {
        if (ar.succeeded()) {
          __args[4](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[4](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_linsert != 'undefined') {
      return __super_linsert.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/llen">llen</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.llen =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["llen(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_llen != 'undefined') {
      return __super_llen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lolwut =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["lolwut(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lolwut != 'undefined') {
      return __super_lolwut.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lpop">lpop</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lpop =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["lpop(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lpop != 'undefined') {
      return __super_lpop.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lpush">lpush</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lpush =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["lpush(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lpush != 'undefined') {
      return __super_lpush.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lpushx =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["lpushx(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lpushx != 'undefined') {
      return __super_lpushx.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lrange">lrange</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lrange =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["lrange(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lrange != 'undefined') {
      return __super_lrange.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lrem">lrem</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lrem =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["lrem(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lrem != 'undefined') {
      return __super_lrem.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/lset">lset</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.lset =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["lset(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_lset != 'undefined') {
      return __super_lset.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.ltrim =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["ltrim(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_ltrim != 'undefined') {
      return __super_ltrim.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/memory">memory</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.memory =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["memory(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_memory != 'undefined') {
      return __super_memory.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/mget">mget</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.mget =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["mget(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_mget != 'undefined') {
      return __super_mget.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/migrate">migrate</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.migrate =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["migrate(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_migrate != 'undefined') {
      return __super_migrate.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/module">module</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.module =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["module(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_module != 'undefined') {
      return __super_module.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/monitor">monitor</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.monitor =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["monitor(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_monitor != 'undefined') {
      return __super_monitor.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/move">move</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.move =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["move(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_move != 'undefined') {
      return __super_move.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/mset">mset</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.mset =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["mset(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_mset != 'undefined') {
      return __super_mset.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.msetnx =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["msetnx(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_msetnx != 'undefined') {
      return __super_msetnx.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/multi">multi</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.multi =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["multi(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_multi != 'undefined') {
      return __super_multi.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/object">object</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.object =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["object(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_object != 'undefined') {
      return __super_object.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/persist">persist</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.persist =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["persist(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_persist != 'undefined') {
      return __super_persist.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pexpire =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["pexpire(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pexpire != 'undefined') {
      return __super_pexpire.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pexpireat =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["pexpireat(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pexpireat != 'undefined') {
      return __super_pexpireat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pfadd =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["pfadd(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pfadd != 'undefined') {
      return __super_pfadd.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pfcount =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["pfcount(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pfcount != 'undefined') {
      return __super_pfcount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pfdebug =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["pfdebug(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pfdebug != 'undefined') {
      return __super_pfdebug.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pfmerge =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["pfmerge(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pfmerge != 'undefined') {
      return __super_pfmerge.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pfselftest =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["pfselftest(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pfselftest != 'undefined') {
      return __super_pfselftest.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/ping">ping</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.ping =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["ping(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_ping != 'undefined') {
      return __super_ping.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/post">post</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.post =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["post(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_post != 'undefined') {
      return __super_post.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/psetex">psetex</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.psetex =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["psetex(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_psetex != 'undefined') {
      return __super_psetex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.psubscribe =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["psubscribe(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_psubscribe != 'undefined') {
      return __super_psubscribe.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/psync">psync</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.psync =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["psync(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_psync != 'undefined') {
      return __super_psync.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pttl">pttl</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pttl =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["pttl(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pttl != 'undefined') {
      return __super_pttl.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/publish">publish</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.publish =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["publish(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_publish != 'undefined') {
      return __super_publish.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.pubsub =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["pubsub(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_pubsub != 'undefined') {
      return __super_pubsub.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.punsubscribe =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["punsubscribe(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_punsubscribe != 'undefined') {
      return __super_punsubscribe.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.randomkey =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["randomkey(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_randomkey != 'undefined') {
      return __super_randomkey.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/readonly">readonly</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.readonly =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["readonly(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_readonly != 'undefined') {
      return __super_readonly.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.readwrite =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["readwrite(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_readwrite != 'undefined') {
      return __super_readwrite.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/rename">rename</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.rename =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["rename(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_rename != 'undefined') {
      return __super_rename.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.renamenx =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["renamenx(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_renamenx != 'undefined') {
      return __super_renamenx.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/replconf">replconf</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.replconf =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["replconf(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_replconf != 'undefined') {
      return __super_replconf.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.replicaof =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["replicaof(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_replicaof != 'undefined') {
      return __super_replicaof.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/restore">restore</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.restore =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["restore(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_restore != 'undefined') {
      return __super_restore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.restoreAsking =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["restoreAsking(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_restoreAsking != 'undefined') {
      return __super_restoreAsking.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/role">role</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.role =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["role(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_role != 'undefined') {
      return __super_role.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/rpop">rpop</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.rpop =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["rpop(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_rpop != 'undefined') {
      return __super_rpop.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.rpoplpush =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["rpoplpush(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_rpoplpush != 'undefined') {
      return __super_rpoplpush.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/rpush">rpush</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.rpush =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["rpush(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_rpush != 'undefined') {
      return __super_rpush.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.rpushx =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["rpushx(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_rpushx != 'undefined') {
      return __super_rpushx.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sadd">sadd</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sadd =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sadd(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sadd != 'undefined') {
      return __super_sadd.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/save">save</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.save =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["save(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_save != 'undefined') {
      return __super_save.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/scan">scan</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.scan =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["scan(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_scan != 'undefined') {
      return __super_scan.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/scard">scard</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.scard =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["scard(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_scard != 'undefined') {
      return __super_scard.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/script">script</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.script =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["script(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_script != 'undefined') {
      return __super_script.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sdiff =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sdiff(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sdiff != 'undefined') {
      return __super_sdiff.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sdiffstore =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sdiffstore(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sdiffstore != 'undefined') {
      return __super_sdiffstore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/select">select</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.select =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["select(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_select != 'undefined') {
      return __super_select.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/set">set</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.set =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["set(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_set != 'undefined') {
      return __super_set.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/setbit">setbit</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.setbit =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["setbit(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_setbit != 'undefined') {
      return __super_setbit.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/setex">setex</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.setex =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["setex(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_setex != 'undefined') {
      return __super_setex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/setnx">setnx</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.setnx =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["setnx(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_setnx != 'undefined') {
      return __super_setnx.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/setrange">setrange</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.setrange =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["setrange(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_setrange != 'undefined') {
      return __super_setrange.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.shutdown =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["shutdown(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_shutdown != 'undefined') {
      return __super_shutdown.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sinter">sinter</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sinter =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sinter(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sinter != 'undefined') {
      return __super_sinter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sinterstore =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sinterstore(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sinterstore != 'undefined') {
      return __super_sinterstore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sismember">sismember</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sismember =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["sismember(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sismember != 'undefined') {
      return __super_sismember.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.slaveof =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["slaveof(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_slaveof != 'undefined') {
      return __super_slaveof.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.slowlog =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["slowlog(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_slowlog != 'undefined') {
      return __super_slowlog.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/smembers">smembers</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.smembers =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["smembers(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_smembers != 'undefined') {
      return __super_smembers.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/smove">smove</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.smove =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["smove(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_smove != 'undefined') {
      return __super_smove.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sort">sort</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sort =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sort(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sort != 'undefined') {
      return __super_sort.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/spop">spop</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.spop =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["spop(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_spop != 'undefined') {
      return __super_spop.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.srandmember =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["srandmember(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_srandmember != 'undefined') {
      return __super_srandmember.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/srem">srem</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.srem =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["srem(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_srem != 'undefined') {
      return __super_srem.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sscan">sscan</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sscan =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sscan(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sscan != 'undefined') {
      return __super_sscan.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/strlen">strlen</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.strlen =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["strlen(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_strlen != 'undefined') {
      return __super_strlen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.subscribe =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["subscribe(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_subscribe != 'undefined') {
      return __super_subscribe.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/substr">substr</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.substr =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["substr(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_substr != 'undefined') {
      return __super_substr.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sunion">sunion</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sunion =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sunion(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sunion != 'undefined') {
      return __super_sunion.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sunionstore =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["sunionstore(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sunionstore != 'undefined') {
      return __super_sunionstore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.swapdb =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["swapdb(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_swapdb != 'undefined') {
      return __super_swapdb.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/sync">sync</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.sync =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["sync(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_sync != 'undefined') {
      return __super_sync.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/time">time</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.time =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["time(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_time != 'undefined') {
      return __super_time.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/touch">touch</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.touch =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["touch(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_touch != 'undefined') {
      return __super_touch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/ttl">ttl</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.ttl =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["ttl(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_ttl != 'undefined') {
      return __super_ttl.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/type">type</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.type =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["type(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_type != 'undefined') {
      return __super_type.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/unlink">unlink</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.unlink =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["unlink(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_unlink != 'undefined') {
      return __super_unlink.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.unsubscribe =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["unsubscribe(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_unsubscribe != 'undefined') {
      return __super_unsubscribe.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.

   @public
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.unwatch =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_redisAPI["unwatch(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_unwatch != 'undefined') {
      return __super_unwatch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/wait">wait</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.wait =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["wait(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_wait != 'undefined') {
      return __super_wait.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/watch">watch</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.watch =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["watch(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_watch != 'undefined') {
      return __super_watch.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xack">xack</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xack =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xack(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xack != 'undefined') {
      return __super_xack.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xadd">xadd</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xadd =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xadd(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xadd != 'undefined') {
      return __super_xadd.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xclaim =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xclaim(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xclaim != 'undefined') {
      return __super_xclaim.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xdel">xdel</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xdel =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xdel(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xdel != 'undefined') {
      return __super_xdel.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xgroup =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xgroup(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xgroup != 'undefined') {
      return __super_xgroup.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xinfo =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xinfo(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xinfo != 'undefined') {
      return __super_xinfo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xlen">xlen</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xlen =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["xlen(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xlen != 'undefined') {
      return __super_xlen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xpending">xpending</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xpending =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xpending(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xpending != 'undefined') {
      return __super_xpending.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xrange">xrange</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xrange =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xrange(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xrange != 'undefined') {
      return __super_xrange.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xread">xread</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xread =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xread(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xread != 'undefined') {
      return __super_xread.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xreadgroup =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xreadgroup(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xreadgroup != 'undefined') {
      return __super_xreadgroup.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xrevrange =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xrevrange(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xrevrange != 'undefined') {
      return __super_xrevrange.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xsetid =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["xsetid(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xsetid != 'undefined') {
      return __super_xsetid.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.xtrim =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["xtrim(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_xtrim != 'undefined') {
      return __super_xtrim.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zadd">zadd</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zadd =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zadd(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zadd != 'undefined') {
      return __super_zadd.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zcard">zcard</a>.

   @public
   @param arg0 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zcard =  function(arg0, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_redisAPI["zcard(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zcard != 'undefined') {
      return __super_zcard.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zcount">zcount</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zcount =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["zcount(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zcount != 'undefined') {
      return __super_zcount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zincrby =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["zincrby(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zincrby != 'undefined') {
      return __super_zincrby.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zinterstore =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zinterstore(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zinterstore != 'undefined') {
      return __super_zinterstore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zlexcount =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["zlexcount(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zlexcount != 'undefined') {
      return __super_zlexcount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zpopmax =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zpopmax(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zpopmax != 'undefined') {
      return __super_zpopmax.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zpopmin =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zpopmin(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zpopmin != 'undefined') {
      return __super_zpopmin.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrange">zrange</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrange =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zrange(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrange != 'undefined') {
      return __super_zrange.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrangebylex =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zrangebylex(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrangebylex != 'undefined') {
      return __super_zrangebylex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrangebyscore =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zrangebyscore(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrangebyscore != 'undefined') {
      return __super_zrangebyscore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrank">zrank</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrank =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["zrank(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrank != 'undefined') {
      return __super_zrank.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrem">zrem</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrem =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zrem(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrem != 'undefined') {
      return __super_zrem.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zremrangebylex =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["zremrangebylex(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zremrangebylex != 'undefined') {
      return __super_zremrangebylex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zremrangebyrank =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["zremrangebyrank(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zremrangebyrank != 'undefined') {
      return __super_zremrangebyrank.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zremrangebyscore =  function(arg0, arg1, arg2, handler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_redisAPI["zremrangebyscore(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zremrangebyscore != 'undefined') {
      return __super_zremrangebyscore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrevrange =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zrevrange(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrevrange != 'undefined') {
      return __super_zrevrange.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrevrangebylex =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zrevrangebylex(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrevrangebylex != 'undefined') {
      return __super_zrevrangebylex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrevrangebyscore =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zrevrangebyscore(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrevrangebyscore != 'undefined') {
      return __super_zrevrangebyscore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zrevrank =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["zrevrank(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zrevrank != 'undefined') {
      return __super_zrevrank.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zscan">zscan</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zscan =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zscan(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zscan != 'undefined') {
      return __super_zscan.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zscore">zscore</a>.

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zscore =  function(arg0, arg1, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_redisAPI["zscore(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zscore != 'undefined') {
      return __super_zscore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.

   @public
   @param args {Array.<string>} 
   @param handler {function} 
   @return {RedisAPI} fluent self
   */
  this.zunionstore =  function(args, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_redisAPI["zunionstore(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(Response, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_zunionstore != 'undefined') {
      return __super_zunionstore.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_redisAPI;
};

RedisAPI._jclass = utils.getJavaClass("io.vertx.redis.client.RedisAPI");
RedisAPI._jtype = {accept: function(obj) {
    return RedisAPI._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(RedisAPI.prototype, {});
    RedisAPI.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RedisAPI._create = function(jdel) {var obj = Object.create(RedisAPI.prototype, {});
  RedisAPI.apply(obj, arguments);
  return obj;
}
module.exports = RedisAPI;