/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/query */
var utils = require('vertx-js/util/utils');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JQuery = Java.type('io.vertx.sqlclient.Query');

/**
 A query.

 @class
*/
var Query = function(j_val, j_arg_0) {

  var j_query = j_val;
  var that = this;
  var j_T = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;
  var __super_execute = this.execute;
  var __super_mapping = this.mapping;
  /**
   Execute the query.

   @public
   @param handler {function} the handler receiving the response 
   */
  this.execute =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_query["execute(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](j_T.wrap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_execute != 'undefined') {
      return __super_execute.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Use the specified <code>mapper</code> for mapping {@link Row} to <code><U></code>.

   @public
   @param mapper {function} 
   @return {Query}
   */
  this.mapping =  function(mapper) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnVertxGen(Query, j_query["mapping(java.util.function.Function)"](function(jVal) {
        var jRet = __args[0](utils.convReturnVertxGen(Row, jVal));
        return utils.convParamTypeUnknown(jRet);
      }), RowSet._jtype) ;
    } else if (typeof __super_mapping != 'undefined') {
      return __super_mapping.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_query;
};

Query._jclass = utils.getJavaClass("io.vertx.sqlclient.Query");
Query._jtype = {accept: function(obj) {
    return Query._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Query.prototype, {});
    Query.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Query._create = function(jdel) {var obj = Object.create(Query.prototype, {});
  Query.apply(obj, arguments);
  return obj;
}
module.exports = Query;