/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/sql_connection */
var utils = require('vertx-js/util/utils');
var SqlClient = require('vertx-sql-client-js/sql_client');
var Query = require('vertx-sql-client-js/query');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var Transaction = require('vertx-sql-client-js/transaction');
var DatabaseMetadata = require('vertx-sql-client-js/database_metadata');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');
var PreparedStatement = require('vertx-sql-client-js/prepared_statement');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JSqlConnection = Java.type('io.vertx.sqlclient.SqlConnection');

/**
 A connection to database server.

 @class
*/
var SqlConnection = function(j_val) {

  var j_sqlConnection = j_val;
  var that = this;
  SqlClient.call(this, j_val);

  var __super_prepare = this.prepare;
  var __super_exceptionHandler = this.exceptionHandler;
  var __super_closeHandler = this.closeHandler;
  var __super_begin = this.begin;
  var __super_isSSL = this.isSSL;
  var __super_close = this.close;
  var __super_databaseMetadata = this.databaseMetadata;
  /**
   Create a prepared query.

   @public
   @param sql {string} the sql 
   @param handler {function} the handler notified with the prepared query asynchronously 
   @return {SqlConnection}
   */
  this.prepare =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_sqlConnection["prepare(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PreparedStatement, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_prepare != 'undefined') {
      return __super_prepare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an handler called with connection errors.

   @public
   @param handler {function} the handler 
   @return {SqlConnection} a reference to this, so the API can be used fluently
   */
  this.exceptionHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_sqlConnection["exceptionHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else if (typeof __super_exceptionHandler != 'undefined') {
      return __super_exceptionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an handler called when the connection is closed.

   @public
   @param handler {function} the handler 
   @return {SqlConnection} a reference to this, so the API can be used fluently
   */
  this.closeHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_sqlConnection["closeHandler(io.vertx.core.Handler)"](__args[0]) ;
      return that;
    } else if (typeof __super_closeHandler != 'undefined') {
      return __super_closeHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Begin a transaction and returns a {@link Transaction} for controlling and tracking
   this transaction.
   <p/>
   When the connection is explicitely closed, any inflight transaction is rollbacked.

   @public

   @return {Transaction} the transaction instance
   */
  this.begin =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Transaction, j_sqlConnection["begin()"]()) ;
    } else if (typeof __super_begin != 'undefined') {
      return __super_begin.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} whether the connection uses SSL
   */
  this.isSSL =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_sqlConnection["isSSL()"]() ;
    } else if (typeof __super_isSSL != 'undefined') {
      return __super_isSSL.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the current connection after all the pending commands have been processed.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_sqlConnection["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {DatabaseMetadata} The static metadata about the backend database server for this connection
   */
  this.databaseMetadata =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(DatabaseMetadata, j_sqlConnection["databaseMetadata()"]()) ;
    } else if (typeof __super_databaseMetadata != 'undefined') {
      return __super_databaseMetadata.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_sqlConnection;
};

SqlConnection._jclass = utils.getJavaClass("io.vertx.sqlclient.SqlConnection");
SqlConnection._jtype = {accept: function(obj) {
    return SqlConnection._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(SqlConnection.prototype, {});
    SqlConnection.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
SqlConnection._create = function(jdel) {var obj = Object.create(SqlConnection.prototype, {});
  SqlConnection.apply(obj, arguments);
  return obj;
}
module.exports = SqlConnection;