/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-mongo-js/mongo_service */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var MongoClient = require('vertx-mongo-js/mongo_client');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JMongoService = Java.type('io.vertx.ext.mongo.MongoService');
var MongoClientDeleteResult = Java.type('io.vertx.ext.mongo.MongoClientDeleteResult');
var IndexOptions = Java.type('io.vertx.ext.mongo.IndexOptions');
var BulkOperation = Java.type('io.vertx.ext.mongo.BulkOperation');
var BulkWriteOptions = Java.type('io.vertx.ext.mongo.BulkWriteOptions');
var FindOptions = Java.type('io.vertx.ext.mongo.FindOptions');
var MongoClientBulkWriteResult = Java.type('io.vertx.ext.mongo.MongoClientBulkWriteResult');
var MongoClientUpdateResult = Java.type('io.vertx.ext.mongo.MongoClientUpdateResult');
var UpdateOptions = Java.type('io.vertx.ext.mongo.UpdateOptions');

/**

 @class
*/
var MongoService = function(j_val) {

  var j_mongoService = j_val;
  var that = this;
  MongoClient.call(this, j_val);

  var __super_createEventBusProxy = this.createEventBusProxy;
  var __super_save = this.save;
  var __super_saveWithOptions = this.saveWithOptions;
  var __super_insert = this.insert;
  var __super_insertWithOptions = this.insertWithOptions;
  var __super_update = this.update;
  var __super_updateCollection = this.updateCollection;
  var __super_updateWithOptions = this.updateWithOptions;
  var __super_updateCollectionWithOptions = this.updateCollectionWithOptions;
  var __super_replace = this.replace;
  var __super_replaceDocuments = this.replaceDocuments;
  var __super_replaceWithOptions = this.replaceWithOptions;
  var __super_replaceDocumentsWithOptions = this.replaceDocumentsWithOptions;
  var __super_bulkWrite = this.bulkWrite;
  var __super_bulkWriteWithOptions = this.bulkWriteWithOptions;
  var __super_find = this.find;
  var __super_findWithOptions = this.findWithOptions;
  var __super_findOne = this.findOne;
  var __super_findOneAndUpdate = this.findOneAndUpdate;
  var __super_findOneAndUpdateWithOptions = this.findOneAndUpdateWithOptions;
  var __super_findOneAndReplace = this.findOneAndReplace;
  var __super_findOneAndReplaceWithOptions = this.findOneAndReplaceWithOptions;
  var __super_findOneAndDelete = this.findOneAndDelete;
  var __super_findOneAndDeleteWithOptions = this.findOneAndDeleteWithOptions;
  var __super_count = this.count;
  var __super_remove = this.remove;
  var __super_removeDocuments = this.removeDocuments;
  var __super_removeWithOptions = this.removeWithOptions;
  var __super_removeDocumentsWithOptions = this.removeDocumentsWithOptions;
  var __super_removeOne = this.removeOne;
  var __super_removeDocument = this.removeDocument;
  var __super_removeOneWithOptions = this.removeOneWithOptions;
  var __super_removeDocumentWithOptions = this.removeDocumentWithOptions;
  var __super_createCollection = this.createCollection;
  var __super_getCollections = this.getCollections;
  var __super_dropCollection = this.dropCollection;
  var __super_createIndex = this.createIndex;
  var __super_createIndexWithOptions = this.createIndexWithOptions;
  var __super_listIndexes = this.listIndexes;
  var __super_dropIndex = this.dropIndex;
  var __super_runCommand = this.runCommand;
  var __super_distinct = this.distinct;
  var __super_distinctWithQuery = this.distinctWithQuery;
  var __super_close = this.close;
  /**

   @public
   @param collection {string} 
   @param document {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.save =  function(collection, document, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["save(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](ar.result(), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_save != 'undefined') {
      return __super_save.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param document {Object} 
   @param writeOption {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.saveWithOptions =  function(collection, document, writeOption, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'string' || __args[2] == null) && typeof __args[3] === 'function') {
      j_mongoService["saveWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), __args[2] == null ? null : io.vertx.ext.mongo.WriteOption.valueOf(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](ar.result(), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_saveWithOptions != 'undefined') {
      return __super_saveWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param document {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.insert =  function(collection, document, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["insert(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](ar.result(), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_insert != 'undefined') {
      return __super_insert.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param document {Object} 
   @param writeOption {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.insertWithOptions =  function(collection, document, writeOption, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'string' || __args[2] == null) && typeof __args[3] === 'function') {
      j_mongoService["insertWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), __args[2] == null ? null : io.vertx.ext.mongo.WriteOption.valueOf(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](ar.result(), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_insertWithOptions != 'undefined') {
      return __super_insertWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param update {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.update =  function(collection, query, update, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["update(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_update != 'undefined') {
      return __super_update.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param update {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.updateCollection =  function(collection, query, update, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["updateCollection(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateCollection != 'undefined') {
      return __super_updateCollection.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param update {Object} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.updateWithOptions =  function(collection, query, update, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoService["updateWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), __args[3]  != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(__args[3]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[4](null, null);
        } else {
          __args[4](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateWithOptions != 'undefined') {
      return __super_updateWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param update {Object} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.updateCollectionWithOptions =  function(collection, query, update, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoService["updateCollectionWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), __args[3]  != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(__args[3]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[4](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[4](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateCollectionWithOptions != 'undefined') {
      return __super_updateCollectionWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param replace {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.replace =  function(collection, query, replace, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["replace(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_replace != 'undefined') {
      return __super_replace.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param replace {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.replaceDocuments =  function(collection, query, replace, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["replaceDocuments(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_replaceDocuments != 'undefined') {
      return __super_replaceDocuments.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param replace {Object} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.replaceWithOptions =  function(collection, query, replace, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoService["replaceWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), __args[3]  != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(__args[3]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[4](null, null);
        } else {
          __args[4](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_replaceWithOptions != 'undefined') {
      return __super_replaceWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param replace {Object} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.replaceDocumentsWithOptions =  function(collection, query, replace, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoService["replaceDocumentsWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), __args[3]  != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(__args[3]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[4](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[4](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_replaceDocumentsWithOptions != 'undefined') {
      return __super_replaceDocumentsWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param operations {Array.<Object>} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.bulkWrite =  function(collection, operations, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_mongoService["bulkWrite(java.lang.String,java.util.List,io.vertx.core.Handler)"](__args[0], utils.convParamListDataObject(__args[1], function(json) { return new BulkOperation(json); }), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bulkWrite != 'undefined') {
      return __super_bulkWrite.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param operations {Array.<Object>} 
   @param bulkWriteOptions {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.bulkWriteWithOptions =  function(collection, operations, bulkWriteOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["bulkWriteWithOptions(java.lang.String,java.util.List,io.vertx.ext.mongo.BulkWriteOptions,io.vertx.core.Handler)"](__args[0], utils.convParamListDataObject(__args[1], function(json) { return new BulkOperation(json); }), __args[2]  != null ? new BulkWriteOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_bulkWriteWithOptions != 'undefined') {
      return __super_bulkWriteWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.find =  function(collection, query, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["find(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_find != 'undefined') {
      return __super_find.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.findWithOptions =  function(collection, query, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["findWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), __args[2]  != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_findWithOptions != 'undefined') {
      return __super_findWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param fields {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.findOne =  function(collection, query, fields, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'object' && typeof __args[3] === 'function') {
      j_mongoService["findOne(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnJson(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_findOne != 'undefined') {
      return __super_findOne.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param update {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.findOneAndUpdate =  function(collection, query, update, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["findOneAndUpdate(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnJson(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_findOneAndUpdate != 'undefined') {
      return __super_findOneAndUpdate.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param update {Object} 
   @param findOptions {Object} 
   @param updateOptions {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.findOneAndUpdateWithOptions =  function(collection, query, update, findOptions, updateOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 6 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && (typeof __args[4] === 'object' && __args[4] != null) && typeof __args[5] === 'function') {
      j_mongoService["findOneAndUpdateWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), __args[3]  != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(__args[3]))) : null, __args[4]  != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(__args[4]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[5](utils.convReturnJson(ar.result()), null);
        } else {
          __args[5](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_findOneAndUpdateWithOptions != 'undefined') {
      return __super_findOneAndUpdateWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param replace {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.findOneAndReplace =  function(collection, query, replace, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["findOneAndReplace(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnJson(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_findOneAndReplace != 'undefined') {
      return __super_findOneAndReplace.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param update {Object} 
   @param findOptions {Object} 
   @param updateOptions {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.findOneAndReplaceWithOptions =  function(collection, query, update, findOptions, updateOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 6 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && (typeof __args[4] === 'object' && __args[4] != null) && typeof __args[5] === 'function') {
      j_mongoService["findOneAndReplaceWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), utils.convParamJsonObject(__args[2]), __args[3]  != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(__args[3]))) : null, __args[4]  != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(__args[4]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[5](utils.convReturnJson(ar.result()), null);
        } else {
          __args[5](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_findOneAndReplaceWithOptions != 'undefined') {
      return __super_findOneAndReplaceWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.findOneAndDelete =  function(collection, query, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["findOneAndDelete(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnJson(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_findOneAndDelete != 'undefined') {
      return __super_findOneAndDelete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param findOptions {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.findOneAndDeleteWithOptions =  function(collection, query, findOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["findOneAndDeleteWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), __args[2]  != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnJson(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_findOneAndDeleteWithOptions != 'undefined') {
      return __super_findOneAndDeleteWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.count =  function(collection, query, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["count(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnLong(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_count != 'undefined') {
      return __super_count.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.remove =  function(collection, query, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["remove(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_remove != 'undefined') {
      return __super_remove.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.removeDocuments =  function(collection, query, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["removeDocuments(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_removeDocuments != 'undefined') {
      return __super_removeDocuments.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param writeOption {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.removeWithOptions =  function(collection, query, writeOption, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_mongoService["removeWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), io.vertx.ext.mongo.WriteOption.valueOf(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_removeWithOptions != 'undefined') {
      return __super_removeWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param writeOption {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.removeDocumentsWithOptions =  function(collection, query, writeOption, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'string' || __args[2] == null) && typeof __args[3] === 'function') {
      j_mongoService["removeDocumentsWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), __args[2] == null ? null : io.vertx.ext.mongo.WriteOption.valueOf(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_removeDocumentsWithOptions != 'undefined') {
      return __super_removeDocumentsWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.removeOne =  function(collection, query, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["removeOne(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_removeOne != 'undefined') {
      return __super_removeOne.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.removeDocument =  function(collection, query, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["removeDocument(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_removeDocument != 'undefined') {
      return __super_removeDocument.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param writeOption {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.removeOneWithOptions =  function(collection, query, writeOption, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_mongoService["removeOneWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), io.vertx.ext.mongo.WriteOption.valueOf(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_removeOneWithOptions != 'undefined') {
      return __super_removeOneWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param query {Object} 
   @param writeOption {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.removeDocumentWithOptions =  function(collection, query, writeOption, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'string' || __args[2] == null) && typeof __args[3] === 'function') {
      j_mongoService["removeDocumentWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), __args[2] == null ? null : io.vertx.ext.mongo.WriteOption.valueOf(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_removeDocumentWithOptions != 'undefined') {
      return __super_removeDocumentWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collectionName {string} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.createCollection =  function(collectionName, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mongoService["createCollection(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createCollection != 'undefined') {
      return __super_createCollection.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.getCollections =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_mongoService["getCollections(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getCollections != 'undefined') {
      return __super_getCollections.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.dropCollection =  function(collection, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mongoService["dropCollection(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_dropCollection != 'undefined') {
      return __super_dropCollection.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param key {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.createIndex =  function(collection, key, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["createIndex(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createIndex != 'undefined') {
      return __super_createIndex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param key {Object} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.createIndexWithOptions =  function(collection, key, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoService["createIndexWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.IndexOptions,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), __args[2]  != null ? new IndexOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createIndexWithOptions != 'undefined') {
      return __super_createIndexWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.listIndexes =  function(collection, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mongoService["listIndexes(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listIndexes != 'undefined') {
      return __super_listIndexes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param indexName {string} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.dropIndex =  function(collection, indexName, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_mongoService["dropIndex(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_dropIndex != 'undefined') {
      return __super_dropIndex.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param commandName {string} 
   @param command {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.runCommand =  function(commandName, command, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoService["runCommand(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], utils.convParamJsonObject(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnJson(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_runCommand != 'undefined') {
      return __super_runCommand.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param fieldName {string} 
   @param resultClassname {string} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.distinct =  function(collection, fieldName, resultClassname, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_mongoService["distinct(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnJson(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_distinct != 'undefined') {
      return __super_distinct.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param collection {string} 
   @param fieldName {string} 
   @param resultClassname {string} 
   @param query {Object} 
   @param resultHandler {function} 
   @return {MongoService}
   */
  this.distinctWithQuery =  function(collection, fieldName, resultClassname, query, resultHandler) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoService["distinctWithQuery(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], utils.convParamJsonObject(__args[3]), function(ar) {
        if (ar.succeeded()) {
          __args[4](utils.convReturnJson(ar.result()), null);
        } else {
          __args[4](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_distinctWithQuery != 'undefined') {
      return __super_distinctWithQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_mongoService["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_mongoService;
};

MongoService._jclass = utils.getJavaClass("io.vertx.ext.mongo.MongoService");
MongoService._jtype = {accept: function(obj) {
    return MongoService._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MongoService.prototype, {});
    MongoService.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MongoService._create = function(jdel) {var obj = Object.create(MongoService.prototype, {});
  MongoService.apply(obj, arguments);
  return obj;
}
/**
 Create a proxy to a service that is deployed somewhere on the event bus

 @memberof module:vertx-mongo-js/mongo_service
 @param vertx {Vertx} the Vert.x instance 
 @param address {string} the address the service is listening on on the event bus 
 @return {MongoService} the service
 */
MongoService.createEventBusProxy =  function(vertx, address) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(MongoService, JMongoService["createEventBusProxy(io.vertx.core.Vertx,java.lang.String)"](__args[0]._jdel, __args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

MongoService.DEFAULT_POOL_NAME = JMongoService.DEFAULT_POOL_NAME;
MongoService.DEFAULT_DB_NAME = JMongoService.DEFAULT_DB_NAME;
module.exports = MongoService;