/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-sql-client-js/column_descriptor */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JColumnDescriptor = Java.type('io.vertx.sqlclient.desc.ColumnDescriptor');

/**
 @class
*/
var ColumnDescriptor = function(j_val) {

  var j_columnDescriptor = j_val;
  var that = this;

  var __super_name = this.name;
  var __super_isArray = this.isArray;
  var __super_jdbcType = this.jdbcType;
  /**

   @public

   @return {string} the column name
   */
  this.name =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_columnDescriptor["name()"]() ;
    } else if (typeof __super_name != 'undefined') {
      return __super_name.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} whether the column is an array
   */
  this.isArray =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_columnDescriptor["isArray()"]() ;
    } else if (typeof __super_isArray != 'undefined') {
      return __super_isArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object} the most appropriate <code>JDBCType</code>
   */
  this.jdbcType =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnEnum(j_columnDescriptor["jdbcType()"]()) ;
    } else if (typeof __super_jdbcType != 'undefined') {
      return __super_jdbcType.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_columnDescriptor;
};

ColumnDescriptor._jclass = utils.getJavaClass("io.vertx.sqlclient.desc.ColumnDescriptor");
ColumnDescriptor._jtype = {accept: function(obj) {
    return ColumnDescriptor._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ColumnDescriptor.prototype, {});
    ColumnDescriptor.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ColumnDescriptor._create = function(jdel) {var obj = Object.create(ColumnDescriptor.prototype, {});
  ColumnDescriptor.apply(obj, arguments);
  return obj;
}
module.exports = ColumnDescriptor;