/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-amqp-client-js/amqp_message */
var utils = require('vertx-js/util/utils');
var Buffer = require('vertx-js/buffer');
var AmqpMessageBuilder = require('vertx-amqp-client-js/amqp_message_builder');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JAmqpMessage = Java.type('io.vertx.amqp.AmqpMessage');

/**
 Represents an AMQP message.
 <p>
 Reference about the different metadata can be found on
 <a href="http://docs.oasis-open.org/amqp/core/v1.0/amqp-core-messaging-v1.0.html#type-properties">AMQP message properties</a>.
 <p>
 @class
*/
var AmqpMessage = function(j_val) {

  var j_amqpMessage = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_isDurable = this.isDurable;
  var __super_isFirstAcquirer = this.isFirstAcquirer;
  var __super_priority = this.priority;
  var __super_deliveryCount = this.deliveryCount;
  var __super_ttl = this.ttl;
  var __super_id = this.id;
  var __super_address = this.address;
  var __super_replyTo = this.replyTo;
  var __super_correlationId = this.correlationId;
  var __super_isBodyNull = this.isBodyNull;
  var __super_bodyAsBoolean = this.bodyAsBoolean;
  var __super_bodyAsByte = this.bodyAsByte;
  var __super_bodyAsShort = this.bodyAsShort;
  var __super_bodyAsInteger = this.bodyAsInteger;
  var __super_bodyAsLong = this.bodyAsLong;
  var __super_bodyAsFloat = this.bodyAsFloat;
  var __super_bodyAsDouble = this.bodyAsDouble;
  var __super_bodyAsChar = this.bodyAsChar;
  var __super_bodyAsBinary = this.bodyAsBinary;
  var __super_bodyAsString = this.bodyAsString;
  var __super_bodyAsSymbol = this.bodyAsSymbol;
  var __super_bodyAsList = this.bodyAsList;
  var __super_bodyAsJsonObject = this.bodyAsJsonObject;
  var __super_bodyAsJsonArray = this.bodyAsJsonArray;
  var __super_subject = this.subject;
  var __super_contentType = this.contentType;
  var __super_contentEncoding = this.contentEncoding;
  var __super_expiryTime = this.expiryTime;
  var __super_creationTime = this.creationTime;
  var __super_groupId = this.groupId;
  var __super_replyToGroupId = this.replyToGroupId;
  var __super_groupSequence = this.groupSequence;
  var __super_applicationProperties = this.applicationProperties;
  var __super_accepted = this.accepted;
  var __super_rejected = this.rejected;
  var __super_released = this.released;
  var __super_modified = this.modified;
  /**

   @public

   @return {boolean} whether or not the message is durable.
   */
  this.isDurable =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["isDurable()"]() ;
    } else if (typeof __super_isDurable != 'undefined') {
      return __super_isDurable.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} if <code>true</code>, then this message has not been acquired by any other link. If <code>false</code>, then this message MAY have previously been acquired by another link or links.
   */
  this.isFirstAcquirer =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["isFirstAcquirer()"]() ;
    } else if (typeof __super_isFirstAcquirer != 'undefined') {
      return __super_isFirstAcquirer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the relative message priority. Higher numbers indicate higher priority messages. Messages with higher priorities MAY be delivered before those with lower priorities.
   */
  this.priority =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["priority()"]() ;
    } else if (typeof __super_priority != 'undefined') {
      return __super_priority.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the number of unsuccessful previous attempts to deliver this message. If this value is non-zero it can be taken as an indication that the delivery might be a duplicate. On first delivery, the value is zero. It is incremented upon an outcome being settled at the sender, according to rules defined for each outcome.
   */
  this.deliveryCount =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["deliveryCount()"]() ;
    } else if (typeof __super_deliveryCount != 'undefined') {
      return __super_deliveryCount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the duration in milliseconds for which the message is to be considered "live".
   */
  this.ttl =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["ttl()"]() ;
    } else if (typeof __super_ttl != 'undefined') {
      return __super_ttl.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the message id
   */
  this.id =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["id()"]() ;
    } else if (typeof __super_id != 'undefined') {
      return __super_id.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the message address, also named <code>to</code> field
   */
  this.address =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["address()"]() ;
    } else if (typeof __super_address != 'undefined') {
      return __super_address.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} The address of the node to send replies to, if any.
   */
  this.replyTo =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["replyTo()"]() ;
    } else if (typeof __super_replyTo != 'undefined') {
      return __super_replyTo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} The client-specific id that can be used to mark or identify messages between clients.
   */
  this.correlationId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["correlationId()"]() ;
    } else if (typeof __super_correlationId != 'undefined') {
      return __super_correlationId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} whether the body is <code>null</code>. This method returns <code>true</code> is the message does not contain a body or if the message contain a <code>null</code> AMQP value as body.
   */
  this.isBodyNull =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["isBodyNull()"]() ;
    } else if (typeof __super_isBodyNull != 'undefined') {
      return __super_isBodyNull.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} the boolean value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsBoolean =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsBoolean()"]() ;
    } else if (typeof __super_bodyAsBoolean != 'undefined') {
      return __super_bodyAsBoolean.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the byte value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsByte =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsByte()"]() ;
    } else if (typeof __super_bodyAsByte != 'undefined') {
      return __super_bodyAsByte.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the short value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsShort =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsShort()"]() ;
    } else if (typeof __super_bodyAsShort != 'undefined') {
      return __super_bodyAsShort.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the integer value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsInteger =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsInteger()"]() ;
    } else if (typeof __super_bodyAsInteger != 'undefined') {
      return __super_bodyAsInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the long value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsLong =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsLong()"]() ;
    } else if (typeof __super_bodyAsLong != 'undefined') {
      return __super_bodyAsLong.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the float value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsFloat =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsFloat()"]() ;
    } else if (typeof __super_bodyAsFloat != 'undefined') {
      return __super_bodyAsFloat.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the double value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsDouble =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsDouble()"]() ;
    } else if (typeof __super_bodyAsDouble != 'undefined') {
      return __super_bodyAsDouble.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the character value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsChar =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsChar()"]() ;
    } else if (typeof __super_bodyAsChar != 'undefined') {
      return __super_bodyAsChar.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Buffer} the bytes contained in the body. The value must be passed as AMQP data.
   */
  this.bodyAsBinary =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Buffer, j_amqpMessage["bodyAsBinary()"]()) ;
    } else if (typeof __super_bodyAsBinary != 'undefined') {
      return __super_bodyAsBinary.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the string value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsString =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsString()"]() ;
    } else if (typeof __super_bodyAsString != 'undefined') {
      return __super_bodyAsString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} the symbol value contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsSymbol =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["bodyAsSymbol()"]() ;
    } else if (typeof __super_bodyAsSymbol != 'undefined') {
      return __super_bodyAsSymbol.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>} the list of values contained in the body. The value must be passed as AMQP value.
   */
  this.bodyAsList =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetObject(j_amqpMessage["bodyAsList()"]()) ;
    } else if (typeof __super_bodyAsList != 'undefined') {
      return __super_bodyAsList.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object} the JSON object contained in the body. The value must be passed as AMQP data.
   */
  this.bodyAsJsonObject =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_amqpMessage["bodyAsJsonObject()"]()) ;
    } else if (typeof __super_bodyAsJsonObject != 'undefined') {
      return __super_bodyAsJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array} the JSON array contained in the body. The value must be passed as AMQP data.
   */
  this.bodyAsJsonArray =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_amqpMessage["bodyAsJsonArray()"]()) ;
    } else if (typeof __super_bodyAsJsonArray != 'undefined') {
      return __super_bodyAsJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string}
   */
  this.subject =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["subject()"]() ;
    } else if (typeof __super_subject != 'undefined') {
      return __super_subject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string}
   */
  this.contentType =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["contentType()"]() ;
    } else if (typeof __super_contentType != 'undefined') {
      return __super_contentType.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string}
   */
  this.contentEncoding =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["contentEncoding()"]() ;
    } else if (typeof __super_contentEncoding != 'undefined') {
      return __super_contentEncoding.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number}
   */
  this.expiryTime =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["expiryTime()"]() ;
    } else if (typeof __super_expiryTime != 'undefined') {
      return __super_expiryTime.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number}
   */
  this.creationTime =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["creationTime()"]() ;
    } else if (typeof __super_creationTime != 'undefined') {
      return __super_creationTime.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string}
   */
  this.groupId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["groupId()"]() ;
    } else if (typeof __super_groupId != 'undefined') {
      return __super_groupId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string}
   */
  this.replyToGroupId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["replyToGroupId()"]() ;
    } else if (typeof __super_replyToGroupId != 'undefined') {
      return __super_replyToGroupId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number}
   */
  this.groupSequence =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_amqpMessage["groupSequence()"]() ;
    } else if (typeof __super_groupSequence != 'undefined') {
      return __super_groupSequence.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object} the message properties as JSON object.
   */
  this.applicationProperties =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_amqpMessage["applicationProperties()"]()) ;
    } else if (typeof __super_applicationProperties != 'undefined') {
      return __super_applicationProperties.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
   the incoming message. It marks the message as delivered with the <code>accepted</code> status.

   @public

   @return {AmqpMessage} the current {@link AmqpMessage} object
   */
  this.accepted =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_amqpMessage["accepted()"]() ;
      return that;
    } else if (typeof __super_accepted != 'undefined') {
      return __super_accepted.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
   the incoming message as <code>rejected</code>.

   @public

   @return {AmqpMessage} the current {@link AmqpMessage} object
   */
  this.rejected =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_amqpMessage["rejected()"]() ;
      return that;
    } else if (typeof __super_rejected != 'undefined') {
      return __super_rejected.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   When receiving a message, and when auto-acknowledgement is disabled, this method is used to acknowledge
   the incoming message as <code>released</code>.

   @public

   @return {AmqpMessage} the current {@link AmqpMessage} object
   */
  this.released =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_amqpMessage["released()"]() ;
      return that;
    } else if (typeof __super_released != 'undefined') {
      return __super_released.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   When receiving a message,  and when auto-acknowledgement is disabled, this method is used to acknowledge
   the incoming message as <code>modified</code>.

   @public
   @param deliveryFailed {boolean} pass <code>true</code> to increase the failed delivery count 
   @param undeliverableHere {boolean} pass <code>true</code> to prevent re-delivery of this message to the same consumer 
   @return {AmqpMessage} the current {@link AmqpMessage} object
   */
  this.modified =  function(deliveryFailed, undeliverableHere) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] ==='boolean') {
      j_amqpMessage["modified(boolean,boolean)"](__args[0], __args[1]) ;
      return that;
    } else if (typeof __super_modified != 'undefined') {
      return __super_modified.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_amqpMessage;
};

AmqpMessage._jclass = utils.getJavaClass("io.vertx.amqp.AmqpMessage");
AmqpMessage._jtype = {accept: function(obj) {
    return AmqpMessage._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AmqpMessage.prototype, {});
    AmqpMessage.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AmqpMessage._create = function(jdel) {var obj = Object.create(AmqpMessage.prototype, {});
  AmqpMessage.apply(obj, arguments);
  return obj;
}
/**
 Creates a builder to create a new {@link AmqpMessage} copying the metadata from the passed message.

 @memberof module:vertx-amqp-client-js/amqp_message
 @param existing {AmqpMessage} an existing message, must not be <code>null</code>. 
 @return {AmqpMessageBuilder} a builder to create an {@link AmqpMessage}.
 */
AmqpMessage.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(AmqpMessageBuilder, JAmqpMessage["create()"]()) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(AmqpMessageBuilder, JAmqpMessage["create(io.vertx.amqp.AmqpMessage)"](__args[0]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = AmqpMessage;