/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-db2-client-js/db2_connection */
var utils = require('vertx-js/util/utils');
var SqlConnection = require('vertx-sql-client-js/sql_connection');
var Query = require('vertx-sql-client-js/query');
var Vertx = require('vertx-js/vertx');
var Row = require('vertx-sql-client-js/row');
var RowSet = require('vertx-sql-client-js/row_set');
var Transaction = require('vertx-sql-client-js/transaction');
var DatabaseMetadata = require('vertx-sql-client-js/database_metadata');
var PreparedQuery = require('vertx-sql-client-js/prepared_query');
var PreparedStatement = require('vertx-sql-client-js/prepared_statement');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JDB2Connection = Java.type('io.vertx.db2client.DB2Connection');
var DB2ConnectOptions = Java.type('io.vertx.db2client.DB2ConnectOptions');

/**
 A connection to DB2 server.

 @class
*/
var DB2Connection = function(j_val) {

  var j_dB2Connection = j_val;
  var that = this;
  SqlConnection.call(this, j_val);

  var __super_connect = this.connect;
  var __super_connect = this.connect;
  var __super_prepare = this.prepare;
  var __super_exceptionHandler = this.exceptionHandler;
  var __super_closeHandler = this.closeHandler;
  var __super_ping = this.ping;
  var __super_debug = this.debug;
  /**

   @public
   @param sql {string} 
   @param handler {function} 
   @return {DB2Connection}
   */
  this.prepare =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_dB2Connection["prepare(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(PreparedStatement, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_prepare != 'undefined') {
      return __super_prepare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {DB2Connection}
   */
  this.exceptionHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_dB2Connection["exceptionHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnThrowable(jVal));
      }) ;
      return that;
    } else if (typeof __super_exceptionHandler != 'undefined') {
      return __super_exceptionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {DB2Connection}
   */
  this.closeHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_dB2Connection["closeHandler(io.vertx.core.Handler)"](__args[0]) ;
      return that;
    } else if (typeof __super_closeHandler != 'undefined') {
      return __super_closeHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a PING command to check if the server is alive.

   @public
   @param handler {function} the handler notified when the server responses to client 
   @return {DB2Connection} a reference to this, so the API can be used fluently
   */
  this.ping =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_dB2Connection["ping(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_ping != 'undefined') {
      return __super_ping.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Send a DEBUG command to dump debug information to the server's stdout.

   @public
   @param handler {function} the handler notified with the execution result 
   @return {DB2Connection} a reference to this, so the API can be used fluently
   */
  this.debug =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_dB2Connection["debug(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_debug != 'undefined') {
      return __super_debug.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_dB2Connection;
};

DB2Connection._jclass = utils.getJavaClass("io.vertx.db2client.DB2Connection");
DB2Connection._jtype = {accept: function(obj) {
    return DB2Connection._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(DB2Connection.prototype, {});
    DB2Connection.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
DB2Connection._create = function(jdel) {var obj = Object.create(DB2Connection.prototype, {});
  DB2Connection.apply(obj, arguments);
  return obj;
}
/**
 Like {@link DB2Connection#connect} with options build
 from <code>connectionUri</code>.

 @memberof module:vertx-db2-client-js/db2_connection
 @param vertx {Vertx} 
 @param connectionUri {string} 
 @param handler {function} 
 */
DB2Connection.connect =  function() {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
    JDB2Connection["connect(io.vertx.core.Vertx,io.vertx.db2client.DB2ConnectOptions,io.vertx.core.Handler)"](__args[0]._jdel, __args[1]  != null ? new DB2ConnectOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(DB2Connection, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
    JDB2Connection["connect(io.vertx.core.Vertx,java.lang.String,io.vertx.core.Handler)"](__args[0]._jdel, __args[1], function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(DB2Connection, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = DB2Connection;