/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-cassandra-js/mapper */
var utils = require('vertx-js/util/utils');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JMapper = Java.type('io.vertx.cassandra.Mapper');

/**

 @class
*/
var Mapper = function(j_val, j_arg_0) {

  var j_mapper = j_val;
  var that = this;
  var j_T = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;
  var __super_save = this.save;
  var __super_delete = this.delete;
  var __super_get = this.get;
  /**
   Asynchronous save method.

   @public
   @param entity {Object} object to be stored in database 
   @param handler {function} result handler 
   */
  this.save =  function(entity, handler) {
    var __args = arguments;
    if (__args.length === 2 && j_T.accept(__args[0]) && typeof __args[1] === 'function') {
      j_mapper["save(java.lang.Object,io.vertx.core.Handler)"](j_T.unwrap(entity), function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      });
    } else if (__args.length === 1 && j_T.accept(__args[0])) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mapper["save(java.lang.Object,io.vertx.core.Handler)"](j_T.unwrap(entity), function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_save != 'undefined') {
      return __super_save.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Asynchronous delete method based on the column values of the primary key.

   @public
   @param primaryKey {Array.<Object>} primary key used to find row to delete 
   @param handler {function} result handler 
   */
  this.delete =  function(primaryKey, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_mapper["delete(java.util.List,io.vertx.core.Handler)"](utils.convParamListObject(primaryKey), function(ar) {
        if (ar.succeeded()) {
          handler(null, null);
        } else {
          handler(null, ar.cause());
        }
      });
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mapper["delete(java.util.List,io.vertx.core.Handler)"](utils.convParamListObject(primaryKey), function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(null, null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_delete != 'undefined') {
      return __super_delete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Asynchronous get method based on the column values of the primary key.

   @public
   @param primaryKey {Array.<Object>} primary key used to retrieve row 
   @param handler {function} result handler 
   */
  this.get =  function(primaryKey, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_mapper["get(java.util.List,io.vertx.core.Handler)"](utils.convParamListObject(primaryKey), function(ar) {
        if (ar.succeeded()) {
          handler(j_T.wrap(ar.result()), null);
        } else {
          handler(null, ar.cause());
        }
      });
    } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      var __prom = Promise.promise();
      var __prom_completer_handler = function (result, cause) { if (cause === null) { __prom.complete(result); } else { __prom.fail(cause); } };
      j_mapper["get(java.util.List,io.vertx.core.Handler)"](utils.convParamListObject(primaryKey), function(ar) {
        if (ar.succeeded()) {
          __prom_completer_handler(j_T.wrap(ar.result()), null);
        } else {
          __prom_completer_handler(null, ar.cause());
        }
      });
      return __prom.future();
    } else if (typeof __super_get != 'undefined') {
      return __super_get.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_mapper;
};

Mapper._jclass = utils.getJavaClass("io.vertx.cassandra.Mapper");
Mapper._jtype = {accept: function(obj) {
    return Mapper._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Mapper.prototype, {});
    Mapper.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Mapper._create = function(jdel) {var obj = Object.create(Mapper.prototype, {});
  Mapper.apply(obj, arguments);
  return obj;
}
module.exports = Mapper;